/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.SessionTrackingMode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.SessionConfig;
import org.apache.catalina.util.URLEncoder;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.res.StringManager;

public class CoyoteAdapter
implements Adapter {
    private static final Log log = LogFactory.getLog(CoyoteAdapter.class);
    private static final String POWERED_BY = "Servlet/6.0 JSP/3.1 (" + ServerInfo.getServerInfo() + " Java/" + System.getProperty("java.vm.vendor") + "/" + System.getProperty("java.runtime.version") + ")";
    private static final EnumSet<SessionTrackingMode> SSL_ONLY = EnumSet.of(SessionTrackingMode.SSL);
    public static final int ADAPTER_NOTES = 1;
    private static final ThreadLocal<String> THREAD_NAME = ThreadLocal.withInitial(() -> Thread.currentThread().getName());
    private final Connector connector;
    protected static final StringManager sm = StringManager.getManager(CoyoteAdapter.class);

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean asyncDispatch(org.apache.coyote.Request req, org.apache.coyote.Response res, SocketEvent status) throws Exception {
        request = (Request)req.getNote(1);
        response = (Response)res.getNote(1);
        if (request == null) {
            throw new IllegalStateException(CoyoteAdapter.sm.getString("coyoteAdapter.nullRequest"));
        }
        success = true;
        asyncConImpl = request.getAsyncContextInternal();
        req.getRequestProcessor().setWorkerThreadName(CoyoteAdapter.THREAD_NAME.get());
        req.setRequestThread();
        try {
            if (!request.isAsync()) {
                response.setSuspended(false);
            }
            if (status == SocketEvent.TIMEOUT) {
                if (!asyncConImpl.timeout()) {
                    asyncConImpl.setErrorState(null, false);
                }
            } else if (status == SocketEvent.ERROR) {
                success = false;
                t = (Throwable)req.getAttribute("jakarta.servlet.error.exception");
                context = request.getContext();
                oldCL = null;
                try {
                    oldCL = context.bind(false, null);
                    if (req.getReadListener() != null) {
                        req.getReadListener().onError(t);
                    }
                    if (res.getWriteListener() != null) {
                        res.getWriteListener().onError(t);
                    }
                    res.action(ActionCode.CLOSE_NOW, t);
                    asyncConImpl.setErrorState(t, true);
                }
                finally {
                    context.unbind(false, oldCL);
                }
            }
            if (!request.isAsyncDispatching() && request.isAsync()) {
                writeListener = res.getWriteListener();
                readListener = req.getReadListener();
                if (writeListener != null && status == SocketEvent.OPEN_WRITE) {
                    context = request.getContext();
                    oldCL = null;
                    try {
                        oldCL = context.bind(false, null);
                        res.onWritePossible();
                        if (request.isFinished() && req.sendAllDataReadEvent() && readListener != null) {
                            readListener.onAllDataRead();
                        }
                        if (!response.getCoyoteResponse().isExceptionPresent()) ** GOTO lbl77
                        throw response.getCoyoteResponse().getErrorException();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        writeListener.onError(t);
                        res.action(ActionCode.CLOSE_NOW, t);
                        asyncConImpl.setErrorState(t, true);
                    }
                    finally {
                        context.unbind(false, oldCL);
                    }
                } else if (readListener != null && status == SocketEvent.OPEN_READ) {
                    context = request.getContext();
                    oldCL = null;
                    try {
                        oldCL = context.bind(false, null);
                        if (!request.isFinished()) {
                            req.onDataAvailable();
                        }
                        if (request.isFinished() && req.sendAllDataReadEvent()) {
                            readListener.onAllDataRead();
                        }
                        if (request.getCoyoteRequest().isExceptionPresent()) {
                            throw request.getCoyoteRequest().getErrorException();
                        }
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        readListener.onError(t);
                        res.action(ActionCode.CLOSE_NOW, t);
                        asyncConImpl.setErrorState(t, true);
                    }
                    finally {
                        context.unbind(false, oldCL);
                    }
                }
            }
            if (!request.isAsyncDispatching() && request.isAsync() && response.isErrorReportRequired()) {
                this.connector.getService().getContainer().getPipeline().getFirst().invoke(request, response);
            }
            if (request.isAsyncDispatching()) {
                this.connector.getService().getContainer().getPipeline().getFirst().invoke(request, response);
                t = (Throwable)request.getAttribute("jakarta.servlet.error.exception");
                if (t != null) {
                    asyncConImpl.setErrorState(t, true);
                }
            }
            if (!request.isAsync()) {
                request.finishRequest();
                response.finishResponse();
            }
            error = new AtomicBoolean(false);
            res.action(ActionCode.IS_ERROR, error);
            if (error.get()) {
                if (request.isAsyncCompleting()) {
                    res.action(ActionCode.ASYNC_POST_PROCESS, null);
                }
                success = false;
            }
        }
        catch (IOException e) {
            success = false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            success = false;
            CoyoteAdapter.log.error(CoyoteAdapter.sm.getString("coyoteAdapter.asyncDispatch"), t);
        }
        finally {
            if (!success) {
                res.setStatus(500);
            }
            if (!success || !request.isAsync()) {
                time = 0L;
                if (req.getStartTimeNanos() != -1L) {
                    time = System.nanoTime() - req.getStartTimeNanos();
                }
                if ((context = request.getContext()) != null) {
                    context.logAccess(request, response, time, false);
                } else {
                    this.log(req, res, time);
                }
            }
            req.getRequestProcessor().setWorkerThreadName(null);
            req.clearRequestThread();
            if (!success || !request.isAsync()) {
                this.updateWrapperErrorCount(request, response);
                request.recycle();
                response.recycle();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(org.apache.coyote.Request req, org.apache.coyote.Response res) throws Exception {
        block24: {
            Request request2 = (Request)req.getNote(1);
            Response response = (Response)res.getNote(1);
            if (request2 == null) {
                request2 = this.connector.createRequest();
                request2.setCoyoteRequest(req);
                response = this.connector.createResponse();
                response.setCoyoteResponse(res);
                request2.setResponse(response);
                response.setRequest(request2);
                req.setNote(1, request2);
                res.setNote(1, response);
                req.getParameters().setQueryStringCharset(this.connector.getURICharset());
            }
            if (this.connector.getXpoweredBy()) {
                response.addHeader("X-Powered-By", POWERED_BY);
            }
            boolean async = false;
            boolean postParseSuccess = false;
            req.getRequestProcessor().setWorkerThreadName(THREAD_NAME.get());
            req.setRequestThread();
            try {
                postParseSuccess = this.postParseRequest(req, request2, res, response);
                if (postParseSuccess) {
                    request2.setAsyncSupported(this.connector.getService().getContainer().getPipeline().isAsyncSupported());
                    this.connector.getService().getContainer().getPipeline().getFirst().invoke(request2, response);
                }
                if (request2.isAsync()) {
                    async = true;
                    ReadListener readListener = req.getReadListener();
                    if (readListener != null && request2.isFinished()) {
                        ClassLoader oldCL = null;
                        try {
                            oldCL = request2.getContext().bind(false, null);
                            if (req.sendAllDataReadEvent()) {
                                req.getReadListener().onAllDataRead();
                            }
                        }
                        finally {
                            request2.getContext().unbind(false, oldCL);
                        }
                    }
                    Throwable throwable = (Throwable)request2.getAttribute("jakarta.servlet.error.exception");
                    if (!request2.isAsyncCompleting() && throwable != null) {
                        request2.getAsyncContextInternal().setErrorState(throwable, true);
                    }
                    break block24;
                }
                request2.finishRequest();
                response.finishResponse();
            }
            catch (IOException error) {
            }
            finally {
                AtomicBoolean error = new AtomicBoolean(false);
                res.action(ActionCode.IS_ERROR, error);
                if (request2.isAsyncCompleting() && error.get()) {
                    res.action(ActionCode.ASYNC_POST_PROCESS, null);
                    async = false;
                }
                if (!async && postParseSuccess) {
                    Context context = request2.getContext();
                    Host host = request2.getHost();
                    long time = System.nanoTime() - req.getStartTimeNanos();
                    if (context != null) {
                        context.logAccess(request2, response, time, false);
                    } else if (response.isError()) {
                        if (host != null) {
                            host.logAccess(request2, response, time, false);
                        } else {
                            this.connector.getService().getContainer().logAccess(request2, response, time, false);
                        }
                    }
                }
                req.getRequestProcessor().setWorkerThreadName(null);
                req.clearRequestThread();
                if (!async) {
                    this.updateWrapperErrorCount(request2, response);
                    request2.recycle();
                    response.recycle();
                }
            }
        }
    }

    private void updateWrapperErrorCount(Request request2, Response response) {
        Wrapper wrapper;
        if (response.isError() && (wrapper = request2.getWrapper()) != null) {
            wrapper.incrementErrorCount();
        }
    }

    @Override
    public boolean prepare(org.apache.coyote.Request req, org.apache.coyote.Response res) throws IOException, ServletException {
        Request request2 = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        return this.postParseRequest(req, request2, res, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(org.apache.coyote.Request req, org.apache.coyote.Response res, long time) {
        Request request2 = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        if (request2 == null) {
            request2 = this.connector.createRequest();
            request2.setCoyoteRequest(req);
            response = this.connector.createResponse();
            response.setCoyoteResponse(res);
            request2.setResponse(response);
            response.setRequest(request2);
            req.setNote(1, request2);
            res.setNote(1, response);
            req.getParameters().setQueryStringCharset(this.connector.getURICharset());
        }
        try {
            boolean logged = false;
            Context context = request2.mappingData.context;
            Host host = request2.mappingData.host;
            if (context != null) {
                logged = true;
                context.logAccess(request2, response, time, true);
            } else if (host != null) {
                logged = true;
                host.logAccess(request2, response, time, true);
            }
            if (!logged) {
                this.connector.getService().getContainer().logAccess(request2, response, time, true);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.warn(sm.getString("coyoteAdapter.accesslogFail"), t);
        }
        finally {
            this.updateWrapperErrorCount(request2, response);
            request2.recycle();
            response.recycle();
        }
    }

    @Override
    public void checkRecycled(org.apache.coyote.Request req, org.apache.coyote.Response res) {
        Request request2 = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        String messageKey = null;
        if (request2 != null && request2.getHost() != null) {
            messageKey = "coyoteAdapter.checkRecycled.request";
        } else if (response != null && response.getContentWritten() != 0L) {
            messageKey = "coyoteAdapter.checkRecycled.response";
        }
        if (messageKey != null) {
            this.log(req, res, 0L);
            if (this.connector.getState().isAvailable()) {
                if (log.isInfoEnabled()) {
                    log.info(sm.getString(messageKey), new RecycleRequiredException());
                }
            } else if (log.isDebugEnabled()) {
                log.debug(sm.getString(messageKey), new RecycleRequiredException());
            }
        }
    }

    @Override
    public String getDomain() {
        return this.connector.getDomain();
    }

    protected boolean postParseRequest(org.apache.coyote.Request req, Request request2, org.apache.coyote.Response res, Response response) throws IOException, ServletException {
        MessageBytes serverName;
        MessageBytes undecodedURI;
        if (req.scheme().isNull()) {
            req.scheme().setString(this.connector.getScheme());
            request2.setSecure(this.connector.getSecure());
        } else {
            request2.setSecure(req.scheme().equals("https"));
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        } else if (req.getServerPort() == -1) {
            if (req.scheme().equals("https")) {
                req.setServerPort(443);
            } else {
                req.setServerPort(80);
            }
        }
        if (proxyName != null) {
            req.serverName().setString(proxyName);
        }
        if ((undecodedURI = req.requestURI()).equals("*")) {
            if (req.method().equalsIgnoreCase("OPTIONS")) {
                StringBuilder allow = new StringBuilder();
                allow.append("GET, HEAD, POST, PUT, DELETE, OPTIONS");
                if (this.connector.getAllowTrace()) {
                    allow.append(", TRACE");
                }
                res.setHeader("Allow", allow.toString());
                this.connector.getService().getContainer().logAccess(request2, response, 0L, true);
                return false;
            }
            response.sendError(400, "Invalid URI");
        }
        MessageBytes decodedURI = req.decodedURI();
        if (undecodedURI.getType() == 2) {
            if (this.connector.getRejectSuspiciousURIs() && CoyoteAdapter.checkSuspiciousURIs(undecodedURI.getByteChunk())) {
                response.sendError(400, "Invalid URI");
            }
            decodedURI.duplicate(undecodedURI);
            this.parsePathParameters(req, request2);
            try {
                req.getURLDecoder().convert(decodedURI.getByteChunk(), this.connector.getEncodedSolidusHandlingInternal());
            }
            catch (IOException ioe) {
                response.sendError(400, "Invalid URI: " + ioe.getMessage());
            }
            if (CoyoteAdapter.normalize(req.decodedURI(), this.connector.getAllowBackslash())) {
                this.convertURI(decodedURI, request2);
            } else {
                response.sendError(400, "Invalid URI");
            }
        } else {
            decodedURI.toChars();
            CharChunk uriCC = decodedURI.getCharChunk();
            int semicolon = uriCC.indexOf(';');
            if (semicolon > 0) {
                decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), semicolon);
            }
        }
        if (this.connector.getUseIPVHosts()) {
            serverName = req.localName();
            if (serverName.isNull()) {
                res.action(ActionCode.REQ_LOCAL_NAME_ATTRIBUTE, null);
            }
        } else {
            serverName = req.serverName();
        }
        String version = null;
        Context versionContext = null;
        boolean mapRequired = true;
        if (response.isError()) {
            decodedURI.recycle();
        }
        while (mapRequired) {
            String sessionID;
            this.connector.getService().getMapper().map(serverName, decodedURI, version, request2.getMappingData());
            if (request2.getContext() == null) {
                return true;
            }
            if (request2.getServletContext().getEffectiveSessionTrackingModes().contains((Object)SessionTrackingMode.URL) && (sessionID = request2.getPathParameter(SessionConfig.getSessionUriParamName(request2.getContext()))) != null) {
                request2.setRequestedSessionId(sessionID);
                request2.setRequestedSessionURL(true);
            }
            try {
                this.parseSessionCookiesId(request2);
            }
            catch (IllegalArgumentException e) {
                if (!response.isError()) {
                    response.setError();
                    response.sendError(400, e.getMessage());
                }
                return true;
            }
            this.parseSessionSslId(request2);
            sessionID = request2.getRequestedSessionId();
            mapRequired = false;
            if (version == null || request2.getContext() != versionContext) {
                version = null;
                versionContext = null;
                Context[] contexts = request2.getMappingData().contexts;
                if (contexts != null && sessionID != null) {
                    for (int i2 = contexts.length; i2 > 0; --i2) {
                        Context ctxt = contexts[i2 - 1];
                        if (ctxt.getManager().findSession(sessionID) == null) continue;
                        if (ctxt.equals(request2.getMappingData().context)) break;
                        version = ctxt.getWebappVersion();
                        versionContext = ctxt;
                        request2.getMappingData().recycle();
                        mapRequired = true;
                        request2.recycleSessionInfo();
                        request2.recycleCookieInfo(true);
                        break;
                    }
                }
            }
            if (mapRequired || !request2.getContext().getPaused()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException contexts) {
                // empty catch block
            }
            request2.getMappingData().recycle();
            mapRequired = true;
        }
        MessageBytes redirectPathMB = request2.getMappingData().redirectPath;
        if (!redirectPathMB.isNull()) {
            Object redirectPath = URLEncoder.DEFAULT.encode(redirectPathMB.toString(), StandardCharsets.UTF_8);
            String query2 = request2.getQueryString();
            if (request2.isRequestedSessionIdFromURL()) {
                redirectPath = (String)redirectPath + ";" + SessionConfig.getSessionUriParamName(request2.getContext()) + "=" + request2.getRequestedSessionId();
            }
            if (query2 != null) {
                redirectPath = (String)redirectPath + "?" + query2;
            }
            response.sendRedirect((String)redirectPath);
            request2.getContext().logAccess(request2, response, 0L, true);
            return false;
        }
        if (!this.connector.getAllowTrace() && req.method().equalsIgnoreCase("TRACE")) {
            String[] methods;
            Wrapper wrapper = request2.getWrapper();
            Object header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (String method : methods) {
                    if ("TRACE".equals(method)) continue;
                    header = header == null ? method : (String)header + ", " + method;
                }
            }
            if (header != null) {
                res.addHeader("Allow", (String)header);
            }
            response.sendError(405, "TRACE method is not allowed");
            return true;
        }
        this.doConnectorAuthenticationAuthorization(req, request2);
        return true;
    }

    private void doConnectorAuthenticationAuthorization(org.apache.coyote.Request req, Request request2) {
        String authType;
        String username = req.getRemoteUser().toString();
        if (username != null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("coyoteAdapter.authenticate", username));
            }
            if (req.getRemoteUserNeedsAuthorization()) {
                Authenticator authenticator = request2.getContext().getAuthenticator();
                if (!(authenticator instanceof AuthenticatorBase)) {
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("coyoteAdapter.authorize", username));
                    }
                    request2.setUserPrincipal(request2.getContext().getRealm().authenticate(username));
                }
            } else {
                request2.setUserPrincipal(new CoyotePrincipal(username));
            }
        }
        if ((authType = req.getAuthType().toString()) != null) {
            request2.setAuthType(authType);
        }
    }

    protected void parsePathParameters(org.apache.coyote.Request req, Request request2) {
        req.decodedURI().toBytes();
        ByteChunk uriBC = req.decodedURI().getByteChunk();
        int semicolon = uriBC.indexOf(';', 1);
        if (semicolon == -1) {
            return;
        }
        Charset charset = this.connector.getURICharset();
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("coyoteAdapter.debug", "uriBC", uriBC.toString()));
            log.debug(sm.getString("coyoteAdapter.debug", "semicolon", String.valueOf(semicolon)));
            log.debug(sm.getString("coyoteAdapter.debug", "enc", charset.name()));
        }
        while (semicolon > -1) {
            int equals;
            int start = uriBC.getStart();
            int end = uriBC.getEnd();
            int pathParamStart = semicolon + 1;
            int pathParamEnd = ByteChunk.findBytes(uriBC.getBuffer(), start + pathParamStart, end, new byte[]{59, 47});
            String pv = null;
            if (pathParamEnd >= 0) {
                if (charset != null) {
                    pv = new String(uriBC.getBuffer(), start + pathParamStart, pathParamEnd - pathParamStart, charset);
                }
                byte[] buf = uriBC.getBuffer();
                for (int i2 = 0; i2 < end - start - pathParamEnd; ++i2) {
                    buf[start + semicolon + i2] = buf[start + i2 + pathParamEnd];
                }
                uriBC.setBytes(buf, start, end - start - pathParamEnd + semicolon);
            } else {
                if (charset != null) {
                    pv = new String(uriBC.getBuffer(), start + pathParamStart, end - start - pathParamStart, charset);
                }
                uriBC.setEnd(start + semicolon);
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("coyoteAdapter.debug", "pathParamStart", String.valueOf(pathParamStart)));
                log.debug(sm.getString("coyoteAdapter.debug", "pathParamEnd", String.valueOf(pathParamEnd)));
                log.debug(sm.getString("coyoteAdapter.debug", "pv", pv));
            }
            if (pv != null && (equals = pv.indexOf(61)) > -1) {
                String name = pv.substring(0, equals);
                String value = pv.substring(equals + 1);
                request2.addPathParameter(name, value);
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("coyoteAdapter.debug", "equals", String.valueOf(equals)));
                    log.debug(sm.getString("coyoteAdapter.debug", "name", name));
                    log.debug(sm.getString("coyoteAdapter.debug", "value", value));
                }
            }
            semicolon = uriBC.indexOf(';', semicolon);
        }
    }

    protected void parseSessionSslId(Request request2) {
        String sessionId;
        if (request2.getRequestedSessionId() == null && SSL_ONLY.equals(request2.getServletContext().getEffectiveSessionTrackingModes()) && request2.connector.secure && (sessionId = (String)request2.getAttribute("jakarta.servlet.request.ssl_session_id")) != null) {
            request2.setRequestedSessionId(sessionId);
            request2.setRequestedSessionSSL(true);
        }
    }

    protected void parseSessionCookiesId(Request request2) {
        Context context = request2.getMappingData().context;
        if (context != null && !context.getServletContext().getEffectiveSessionTrackingModes().contains((Object)SessionTrackingMode.COOKIE)) {
            return;
        }
        ServerCookies serverCookies = request2.getServerCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        String sessionCookieName = SessionConfig.getSessionCookieName(context);
        for (int i2 = 0; i2 < count; ++i2) {
            ServerCookie scookie = serverCookies.getCookie(i2);
            if (!scookie.getName().equals(sessionCookieName)) continue;
            if (!request2.isRequestedSessionIdFromCookie()) {
                this.convertMB(scookie.getValue());
                request2.setRequestedSessionId(scookie.getValue().toString());
                request2.setRequestedSessionCookie(true);
                request2.setRequestedSessionURL(false);
                if (!log.isDebugEnabled()) continue;
                log.debug(" Requested cookie session id is " + request2.getRequestedSessionId());
                continue;
            }
            if (request2.isRequestedSessionIdValid()) continue;
            this.convertMB(scookie.getValue());
            request2.setRequestedSessionId(scookie.getValue().toString());
        }
    }

    protected void convertURI(MessageBytes uri, Request request2) throws IOException {
        ByteChunk bc = uri.getByteChunk();
        int length = bc.getLength();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(length, -1);
        Charset charset = this.connector.getURICharset();
        B2CConverter conv = request2.getURIConverter();
        if (conv == null) {
            conv = new B2CConverter(charset, false);
            request2.setURIConverter(conv);
        } else {
            conv.recycle();
        }
        try {
            conv.convert(bc, cc, true);
            uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
        }
        catch (IOException ioe) {
            request2.getResponse().sendError(400);
        }
    }

    protected void convertMB(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        CharChunk cc = mb.getCharChunk();
        int length = bc.getLength();
        cc.allocate(length, -1);
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i2 = 0; i2 < length; ++i2) {
            cbuf[i2] = (char)(bbuf[i2 + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, length);
    }

    public static boolean normalize(MessageBytes uriMB, boolean allowBackslash) {
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        boolean appendedSlash = false;
        if (start == end) {
            return false;
        }
        int pos = 0;
        int index = 0;
        if (b[start] != 47 && b[start] != 92) {
            return false;
        }
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                if (allowBackslash) {
                    b[pos] = 47;
                    continue;
                }
                return false;
            }
            if (b[pos] != 0) continue;
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (b[pos] != 47) continue;
            while (pos + 1 < end && b[pos + 1] == 47) {
                CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start >= 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
            appendedSlash = true;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        if (appendedSlash && end > 1 && b[end - 1] == 47) {
            uriBC.setEnd(end - 1);
        }
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        System.arraycopy(b, src, b, dest, len);
    }

    private static boolean checkSuspiciousURIs(ByteChunk undecodedURI) {
        byte[] bytes = undecodedURI.getBytes();
        int start = undecodedURI.getStart();
        int end = undecodedURI.getEnd();
        int segmentStart = -1;
        int segmentEnd = -1;
        segmentStart = undecodedURI.indexOf('/', 0);
        if (segmentStart > -1) {
            segmentEnd = undecodedURI.indexOf('/', segmentStart + 1);
        }
        while (segmentStart > -1) {
            int pos = start + segmentStart + 1;
            if (segmentEnd > 0 && bytes[pos] == 59) {
                return true;
            }
            int dotCount = 0;
            boolean encodedDot = false;
            while (pos < end) {
                if (bytes[pos] == 46) {
                    ++dotCount;
                    ++pos;
                    continue;
                }
                if (pos + 2 < end && bytes[pos] == 37 && bytes[pos + 1] == 50 && (bytes[pos + 2] == 101 || bytes[pos + 2] == 69)) {
                    encodedDot = true;
                    ++dotCount;
                    pos += 3;
                    continue;
                }
                if (bytes[pos] == 59) {
                    if (dotCount <= 0) break;
                    return true;
                }
                if (bytes[pos] == 47) break;
                dotCount = 0;
                break;
            }
            if (dotCount > 0 && encodedDot) {
                return true;
            }
            pos = start + segmentStart + 1;
            while (pos < end) {
                if (pos + 2 < end && bytes[pos] == 37) {
                    byte b1 = bytes[pos + 1];
                    byte b2 = bytes[pos + 2];
                    pos += 3;
                    int decoded = (HexUtils.getDec(b1) << 4) + HexUtils.getDec(b2);
                    if (decoded >= 20 && decoded != 127 && decoded != 47) continue;
                    return true;
                }
                ++pos;
            }
            if (segmentEnd == -1) {
                segmentStart = -1;
                continue;
            }
            segmentStart = segmentEnd;
            if (segmentStart <= -1) continue;
            segmentEnd = undecodedURI.indexOf('/', segmentStart + 1);
        }
        return false;
    }

    private static class RecycleRequiredException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private RecycleRequiredException() {
        }
    }
}

