/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class SemaphoreValve
extends ValveBase {
    protected Semaphore semaphore = null;
    protected int concurrency = 10;
    protected boolean fairness = false;
    protected boolean block = true;
    protected boolean interruptible = false;

    public SemaphoreValve() {
        super(true);
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public boolean getFairness() {
        return this.fairness;
    }

    public void setFairness(boolean fairness) {
        this.fairness = fairness;
    }

    public boolean getBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public boolean getInterruptible() {
        return this.interruptible;
    }

    public void setInterruptible(boolean interruptible) {
        this.interruptible = interruptible;
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        this.semaphore = new Semaphore(this.concurrency, this.fairness);
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.semaphore = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request2, Response response) throws IOException, ServletException {
        if (this.controlConcurrency(request2, response)) {
            boolean shouldRelease = true;
            try {
                if (this.block) {
                    if (this.interruptible) {
                        try {
                            this.semaphore.acquire();
                        }
                        catch (InterruptedException e) {
                            shouldRelease = false;
                            this.permitDenied(request2, response);
                            if (shouldRelease) {
                                this.semaphore.release();
                            }
                            return;
                        }
                    } else {
                        this.semaphore.acquireUninterruptibly();
                    }
                } else if (!this.semaphore.tryAcquire()) {
                    shouldRelease = false;
                    this.permitDenied(request2, response);
                    return;
                }
                this.getNext().invoke(request2, response);
            }
            finally {
                if (shouldRelease) {
                    this.semaphore.release();
                }
            }
        } else {
            this.getNext().invoke(request2, response);
        }
    }

    public boolean controlConcurrency(Request request2, Response response) {
        return true;
    }

    public void permitDenied(Request request2, Response response) throws IOException, ServletException {
    }
}

