/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ByteArrayAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.internal.Paths;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractPathAssert<SELF extends AbstractPathAssert<SELF>>
extends AbstractComparableAssert<SELF, Path> {
    @VisibleForTesting
    protected Paths paths = Paths.instance();
    @VisibleForTesting
    Charset charset = Charset.defaultCharset();

    protected AbstractPathAssert(Path actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Deprecated
    public SELF hasSameContentAs(Path expected) {
        return this.hasSameTextualContentAs(expected);
    }

    public SELF hasSameTextualContentAs(Path expected) {
        this.paths.assertHasSameTextualContentAs(this.info, (Path)this.actual, this.charset, expected, Charset.defaultCharset());
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasSameTextualContentAs(Path expected, Charset expectedCharset) {
        this.paths.assertHasSameTextualContentAs(this.info, (Path)this.actual, this.charset, expected, expectedCharset);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    @Deprecated
    public SELF hasSameContentAs(Path expected, Charset expectedCharset) {
        return this.hasSameTextualContentAs(expected, expectedCharset);
    }

    public SELF hasBinaryContent(byte[] expected) {
        this.paths.assertHasBinaryContent(this.info, (Path)this.actual, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasSameBinaryContentAs(Path expected) {
        this.paths.assertHasSameBinaryContentAs(this.info, (Path)this.actual, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingCharset(String charsetName) {
        Preconditions.checkArgument(Charset.isSupported(charsetName), "Charset:<'%s'> is not supported on this system", charsetName);
        return this.usingCharset(Charset.forName(charsetName));
    }

    @CheckReturnValue
    public SELF usingCharset(Charset charset) {
        this.charset = Objects.requireNonNull(charset, "The charset should not be null");
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasContent(String expected) {
        this.paths.assertHasTextualContent(this.info, (Path)this.actual, expected, this.charset);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasFileSystem(FileSystem expected) {
        this.paths.assertHasFileSystem(this.info, (Path)this.actual, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasSameFileSystemAs(Path expected) {
        this.paths.assertHasSameFileSystemAs(this.info, (Path)this.actual, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isReadable() {
        this.paths.assertIsReadable(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isWritable() {
        this.paths.assertIsWritable(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isExecutable() {
        this.paths.assertIsExecutable(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF exists() {
        this.paths.assertExists(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF existsNoFollowLinks() {
        this.paths.assertExistsNoFollowLinks(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF doesNotExist() {
        this.paths.assertDoesNotExist(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isRegularFile() {
        this.paths.assertIsRegularFile(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isDirectory() {
        this.paths.assertIsDirectory(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isSymbolicLink() {
        this.paths.assertIsSymbolicLink(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isAbsolute() {
        this.paths.assertIsAbsolute(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isRelative() {
        this.paths.assertIsRelative(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isNormalized() {
        this.paths.assertIsNormalized(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isCanonical() {
        this.paths.assertIsCanonical(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasFileName(String fileName) {
        this.paths.assertHasFileName(this.info, (Path)this.actual, fileName);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasParent(Path expected) {
        this.paths.assertHasParent(this.info, (Path)this.actual, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasParentRaw(Path expected) {
        this.paths.assertHasParentRaw(this.info, (Path)this.actual, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasNoParent() {
        this.paths.assertHasNoParent(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasNoParentRaw() {
        this.paths.assertHasNoParentRaw(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasSize(long expectedSize) {
        this.paths.assertHasSize(this.info, (Path)this.actual, expectedSize);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF startsWith(Path other) {
        this.paths.assertStartsWith(this.info, (Path)this.actual, other);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF startsWithRaw(Path other) {
        this.paths.assertStartsWithRaw(this.info, (Path)this.actual, other);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF endsWith(Path other) {
        this.paths.assertEndsWith(this.info, (Path)this.actual, other);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF endsWithRaw(Path other) {
        this.paths.assertEndsWithRaw(this.info, (Path)this.actual, other);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasDigest(MessageDigest digest, byte[] expected) {
        this.paths.assertHasDigest((AssertionInfo)this.info, (Path)this.actual, digest, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasDigest(MessageDigest digest, String expected) {
        this.paths.assertHasDigest((AssertionInfo)this.info, (Path)this.actual, digest, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasDigest(String algorithm, byte[] expected) {
        this.paths.assertHasDigest((AssertionInfo)this.info, (Path)this.actual, algorithm, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasDigest(String algorithm, String expected) {
        this.paths.assertHasDigest((AssertionInfo)this.info, (Path)this.actual, algorithm, expected);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isDirectoryContaining(Predicate<Path> filter2) {
        this.paths.assertIsDirectoryContaining((AssertionInfo)this.info, (Path)this.actual, filter2);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isDirectoryContaining(String syntaxAndPattern) {
        this.paths.assertIsDirectoryContaining((AssertionInfo)this.info, (Path)this.actual, syntaxAndPattern);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isDirectoryRecursivelyContaining(String syntaxAndPattern) {
        this.paths.assertIsDirectoryRecursivelyContaining((AssertionInfo)this.info, (Path)this.actual, syntaxAndPattern);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isDirectoryRecursivelyContaining(Predicate<Path> filter2) {
        this.paths.assertIsDirectoryRecursivelyContaining((AssertionInfo)this.info, (Path)this.actual, filter2);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isDirectoryNotContaining(Predicate<Path> filter2) {
        this.paths.assertIsDirectoryNotContaining((AssertionInfo)this.info, (Path)this.actual, filter2);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isDirectoryNotContaining(String syntaxAndPattern) {
        this.paths.assertIsDirectoryNotContaining((AssertionInfo)this.info, (Path)this.actual, syntaxAndPattern);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isEmptyDirectory() {
        this.paths.assertIsEmptyDirectory(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isNotEmptyDirectory() {
        this.paths.assertIsNotEmptyDirectory(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isEmptyFile() {
        this.paths.assertIsEmptyFile(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF isNotEmptyFile() {
        this.paths.assertIsNotEmptyFile(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public AbstractByteArrayAssert<?> binaryContent() {
        this.paths.assertIsReadable(this.info, (Path)this.actual);
        return (AbstractByteArrayAssert)new ByteArrayAssert(this.readPath()).withAssertionState(this.myself);
    }

    public AbstractStringAssert<?> content() {
        return this.internalContent(Charset.defaultCharset());
    }

    public AbstractStringAssert<?> content(Charset charset) {
        return this.internalContent(charset);
    }

    private AbstractStringAssert<?> internalContent(Charset charset) {
        this.paths.assertIsReadable(this.info, (Path)this.actual);
        String pathContent = this.readPath(charset);
        return (AbstractStringAssert)new StringAssert(pathContent).withAssertionState(this.myself);
    }

    private byte[] readPath() {
        try {
            return Files.readAllBytes((Path)this.actual);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to read %s binary content", this.actual), e);
        }
    }

    private String readPath(Charset charset) {
        try {
            return new String(Files.readAllBytes((Path)this.actual), charset);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to read %s content with %s charset", this.actual, charset), e);
        }
    }

    public SELF hasExtension(String expectedExtension) {
        this.paths.assertHasExtension(this.info, (Path)this.actual, expectedExtension);
        return (SELF)((AbstractPathAssert)this.myself);
    }

    public SELF hasNoExtension() {
        this.paths.assertHasNoExtension(this.info, (Path)this.actual);
        return (SELF)((AbstractPathAssert)this.myself);
    }
}

