/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.FileVisitOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAbsolutePath;
import org.assertj.core.error.ShouldBeDirectory;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeEmptyDirectory;
import org.assertj.core.error.ShouldBeFile;
import org.assertj.core.error.ShouldBeReadable;
import org.assertj.core.error.ShouldBeRelativePath;
import org.assertj.core.error.ShouldBeWritable;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainRecursively;
import org.assertj.core.error.ShouldExist;
import org.assertj.core.error.ShouldHaveBinaryContent;
import org.assertj.core.error.ShouldHaveContent;
import org.assertj.core.error.ShouldHaveDigest;
import org.assertj.core.error.ShouldHaveExtension;
import org.assertj.core.error.ShouldHaveName;
import org.assertj.core.error.ShouldHaveNoExtension;
import org.assertj.core.error.ShouldHaveNoParent;
import org.assertj.core.error.ShouldHaveParent;
import org.assertj.core.error.ShouldHaveSameContent;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotExist;
import org.assertj.core.internal.BinaryDiff;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.internal.Digests;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.NioFilesWrapper;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.diff.Delta;

public class Files {
    private static final String UNABLE_TO_COMPARE_FILE_CONTENTS = "Unable to compare contents of files:<%s> and:<%s>";
    private static final Files INSTANCE = new Files();
    private static final FileFilter ANY = any -> true;
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    BinaryDiff binaryDiff = new BinaryDiff();
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    NioFilesWrapper nioFilesWrapper = NioFilesWrapper.instance();

    public static Files instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Files() {
    }

    public void assertSameContentAs(AssertionInfo info2, File actual, Charset actualCharset, File expected, Charset expectedCharset) {
        this.verifyIsFile(expected);
        this.assertIsFile(info2, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, actualCharset, expected, expectedCharset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (MalformedInputException e) {
            try {
                BinaryDiffResult binaryDiffResult = this.binaryDiff.diff(actual, java.nio.file.Files.readAllBytes(expected.toPath()));
                if (binaryDiffResult.hasNoDiff()) {
                    throw e;
                }
                throw this.failures.failure(info2, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, binaryDiffResult));
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_FILE_CONTENTS, actual, expected), ioe);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_FILE_CONTENTS, actual, expected), e);
        }
    }

    public void assertSameBinaryContentAs(AssertionInfo info2, File actual, File expected) {
        this.verifyIsFile(expected);
        this.assertIsFile(info2, actual);
        try {
            BinaryDiffResult binaryDiffResult = this.binaryDiff.diff(actual, java.nio.file.Files.readAllBytes(expected.toPath()));
            if (binaryDiffResult.hasDiff()) {
                throw this.failures.failure(info2, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, binaryDiffResult));
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(String.format(UNABLE_TO_COMPARE_FILE_CONTENTS, actual, expected), ioe);
        }
    }

    public void assertHasBinaryContent(AssertionInfo info2, File actual, byte[] expected) {
        java.util.Objects.requireNonNull(expected, "The binary content to compare to should not be null");
        this.assertIsFile(info2, actual);
        try {
            BinaryDiffResult result = this.binaryDiff.diff(actual, expected);
            if (result.hasNoDiff()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, result));
        }
        catch (IOException e) {
            String msg = String.format("Unable to verify binary contents of file:<%s>", actual);
            throw new UncheckedIOException(msg, e);
        }
    }

    public void assertHasSizeInBytes(AssertionInfo info2, File actual, long expectedSizeInBytes) {
        this.assertIsFile(info2, actual);
        if (expectedSizeInBytes == actual.length()) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveSize.shouldHaveSize(actual, expectedSizeInBytes));
    }

    public void assertHasContent(AssertionInfo info2, File actual, String expected, Charset charset) {
        java.util.Objects.requireNonNull(expected, "The text to compare to should not be null");
        this.assertIsFile(info2, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected, charset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info2, ShouldHaveContent.shouldHaveContent(actual, charset, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to verify text contents of file:<%s>", actual);
            throw new UncheckedIOException(msg, e);
        }
    }

    public void assertIsFile(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.isFile()) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeFile.shouldBeFile(actual));
    }

    public void assertIsDirectory(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.isDirectory()) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeDirectory.shouldBeDirectory(actual));
    }

    public void assertIsAbsolute(AssertionInfo info2, File actual) {
        if (this.isAbsolutePath(info2, actual)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeAbsolutePath.shouldBeAbsolutePath(actual));
    }

    public void assertIsRelative(AssertionInfo info2, File actual) {
        if (!this.isAbsolutePath(info2, actual)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeRelativePath.shouldBeRelativePath(actual));
    }

    public void assertExists(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.exists()) {
            return;
        }
        throw this.failures.failure(info2, ShouldExist.shouldExist(actual));
    }

    public void assertDoesNotExist(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (!actual.exists()) {
            return;
        }
        throw this.failures.failure(info2, ShouldNotExist.shouldNotExist(actual));
    }

    public void assertCanWrite(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.canWrite()) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeWritable.shouldBeWritable(actual));
    }

    public void assertIsEmptyFile(AssertionInfo info2, File actual) {
        this.assertIsFile(info2, actual);
        if (actual.length() == 0L) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeEmpty.shouldBeEmpty(actual));
    }

    public void assertIsNotEmptyFile(AssertionInfo info2, File actual) {
        this.assertIsFile(info2, actual);
        if (actual.length() > 0L) {
            return;
        }
        throw this.failures.failure(info2, ShouldNotBeEmpty.shouldNotBeEmpty(actual));
    }

    public void assertCanRead(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.canRead()) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeReadable.shouldBeReadable(actual));
    }

    public void assertHasParent(AssertionInfo info2, File actual, File expected) {
        java.util.Objects.requireNonNull(expected, "The expected parent file should not be null.");
        Files.assertNotNull(info2, actual);
        try {
            if (actual.getParentFile() != null && java.util.Objects.equals(expected.getCanonicalFile(), actual.getParentFile().getCanonicalFile())) {
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to get canonical form of [%s] or [%s].", actual, expected), e);
        }
        throw this.failures.failure(info2, ShouldHaveParent.shouldHaveParent(actual, expected));
    }

    public void assertHasExtension(AssertionInfo info2, File actual, String expected) {
        java.util.Objects.requireNonNull(expected, "The expected extension should not be null.");
        this.assertIsFile(info2, actual);
        String extension = this.getFileExtension(actual).orElseThrow(() -> this.failures.failure(info2, ShouldHaveExtension.shouldHaveExtension(actual, expected)));
        if (!expected.equals(extension)) {
            throw this.failures.failure(info2, ShouldHaveExtension.shouldHaveExtension(actual, extension, expected));
        }
    }

    public void assertHasNoExtension(AssertionInfo info2, File actual) {
        this.assertIsFile(info2, actual);
        Optional<String> extension = this.getFileExtension(actual);
        if (extension.isPresent()) {
            throw this.failures.failure(info2, ShouldHaveNoExtension.shouldHaveNoExtension(actual, extension.get()));
        }
    }

    public void assertHasName(AssertionInfo info2, File actual, String expected) {
        Files.assertNotNull(info2, actual);
        java.util.Objects.requireNonNull(expected, "The expected name should not be null.");
        if (expected.equals(actual.getName())) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveName.shouldHaveName(actual, expected));
    }

    public void assertHasNoParent(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        if (actual.getParentFile() == null) {
            return;
        }
        throw this.failures.failure(info2, ShouldHaveNoParent.shouldHaveNoParent(actual));
    }

    public void assertHasDigest(AssertionInfo info2, File actual, MessageDigest digest, byte[] expected) {
        java.util.Objects.requireNonNull(digest, "The message digest algorithm should not be null");
        java.util.Objects.requireNonNull(expected, "The binary representation of digest to compare to should not be null");
        this.assertExists(info2, actual);
        this.assertIsFile(info2, actual);
        this.assertCanRead(info2, actual);
        try (InputStream actualStream = this.nioFilesWrapper.newInputStream(actual.toPath(), new OpenOption[0]);){
            DigestDiff digestDiff = Digests.digestDiff(actualStream, digest, expected);
            if (digestDiff.digestsDiffer()) {
                throw this.failures.failure(info2, ShouldHaveDigest.shouldHaveDigest(actual, digestDiff));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to calculate digest of path:<%s>", actual), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, File actual, MessageDigest digest, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info2, actual, digest, Digests.fromHex(expected));
    }

    public void assertHasDigest(AssertionInfo info2, File actual, String algorithm, byte[] expected) {
        java.util.Objects.requireNonNull(algorithm, "The message digest algorithm should not be null");
        try {
            this.assertHasDigest(info2, actual, MessageDigest.getInstance(algorithm), expected);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Unable to find digest implementation for: <%s>", algorithm), e);
        }
    }

    public void assertHasDigest(AssertionInfo info2, File actual, String algorithm, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info2, actual, algorithm, Digests.fromHex(expected));
    }

    public void assertIsEmptyDirectory(AssertionInfo info2, File actual) {
        List<File> files = this.directoryContent(info2, actual);
        if (!files.isEmpty()) {
            throw this.failures.failure(info2, ShouldBeEmptyDirectory.shouldBeEmptyDirectory(actual, files));
        }
    }

    public void assertIsNotEmptyDirectory(AssertionInfo info2, File actual) {
        boolean isEmptyDirectory = this.directoryContent(info2, actual).isEmpty();
        if (isEmptyDirectory) {
            throw this.failures.failure(info2, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public void assertIsDirectoryContaining(AssertionInfo info2, File actual, Predicate<File> filter2) {
        java.util.Objects.requireNonNull(filter2, "The files filter should not be null");
        this.assertIsDirectoryContaining(info2, actual, filter2::test, "the given filter");
    }

    public void assertIsDirectoryContaining(AssertionInfo info2, File actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern should not be null");
        FileFilter filter2 = Files.fileFilter(info2, actual, syntaxAndPattern);
        this.assertIsDirectoryContaining(info2, actual, filter2, String.format("the '%s' pattern", syntaxAndPattern));
    }

    public void assertIsDirectoryRecursivelyContaining(AssertionInfo info2, File actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern should not be null");
        FileFilter filter2 = Files.fileFilter(info2, actual, syntaxAndPattern);
        this.assertIsDirectoryRecursivelyContaining(info2, actual, filter2::accept, String.format("the '%s' pattern", syntaxAndPattern));
    }

    public void assertIsDirectoryRecursivelyContaining(AssertionInfo info2, File actual, Predicate<File> filter2) {
        java.util.Objects.requireNonNull(filter2, "The files filter should not be null");
        this.assertIsDirectoryRecursivelyContaining(info2, actual, filter2, "the given filter");
    }

    public void assertIsDirectoryNotContaining(AssertionInfo info2, File actual, Predicate<File> filter2) {
        java.util.Objects.requireNonNull(filter2, "The files filter should not be null");
        this.assertIsDirectoryNotContaining(info2, actual, filter2::test, "the given filter");
    }

    public void assertIsDirectoryNotContaining(AssertionInfo info2, File actual, String syntaxAndPattern) {
        java.util.Objects.requireNonNull(syntaxAndPattern, "The syntax and pattern should not be null");
        FileFilter filter2 = Files.fileFilter(info2, actual, syntaxAndPattern);
        this.assertIsDirectoryNotContaining(info2, actual, filter2, String.format("the '%s' pattern", syntaxAndPattern));
    }

    private List<File> filterDirectory(AssertionInfo info2, File actual, FileFilter filter2) {
        this.assertIsDirectory(info2, actual);
        File[] items = actual.listFiles(filter2);
        java.util.Objects.requireNonNull(items, "Directory listing should not be null");
        List<File> files = Lists.list(items);
        files.sort(Comparator.comparing(File::toString));
        return files;
    }

    private List<File> directoryContent(AssertionInfo info2, File actual) {
        return this.filterDirectory(info2, actual, ANY);
    }

    private void assertIsDirectoryContaining(AssertionInfo info2, File actual, FileFilter filter2, String filterPresentation) {
        List<File> matchingFiles = this.filterDirectory(info2, actual, filter2);
        if (matchingFiles.isEmpty()) {
            throw this.failures.failure(info2, ShouldContain.directoryShouldContain(actual, this.directoryContent(info2, actual), filterPresentation));
        }
    }

    private void assertIsDirectoryNotContaining(AssertionInfo info2, File actual, FileFilter filter2, String filterPresentation) {
        List<File> matchingFiles = this.filterDirectory(info2, actual, filter2);
        if (!matchingFiles.isEmpty()) {
            throw this.failures.failure(info2, ShouldNotContain.directoryShouldNotContain(actual, matchingFiles, filterPresentation));
        }
    }

    private boolean isDirectoryRecursivelyContaining(AssertionInfo info2, File actual, Predicate<File> filter2) {
        this.assertIsDirectory(info2, actual);
        try (Stream<File> actualContent = this.recursiveContentOf(actual);){
            boolean bl = actualContent.anyMatch(filter2);
            return bl;
        }
    }

    private List<File> sortedRecursiveContent(File directory) {
        try (Stream<File> fileStream = this.recursiveContentOf(directory);){
            List<File> list = fileStream.sorted(Comparator.comparing(File::getAbsolutePath)).collect(Collectors.toList());
            return list;
        }
    }

    private Stream<File> recursiveContentOf(File directory) {
        Path path = directory.toPath();
        try {
            return java.nio.file.Files.walk(path, new FileVisitOption[0]).filter(p -> !p.equals(path)).map(Path::toFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to walk recursively the directory :<%s>", path), e);
        }
    }

    private void assertIsDirectoryRecursivelyContaining(AssertionInfo info2, File actual, Predicate<File> filter2, String filterPresentation) {
        if (!this.isDirectoryRecursivelyContaining(info2, actual, filter2)) {
            throw this.failures.failure(info2, ShouldContainRecursively.directoryShouldContainRecursively(actual, this.sortedRecursiveContent(actual), filterPresentation));
        }
    }

    private static FileFilter fileFilter(AssertionInfo info2, File actual, String syntaxAndPattern) {
        Files.assertNotNull(info2, actual);
        PathMatcher matcher = actual.toPath().getFileSystem().getPathMatcher(syntaxAndPattern);
        return file -> matcher.matches(file.toPath());
    }

    private static void assertNotNull(AssertionInfo info2, File actual) {
        Objects.instance().assertNotNull(info2, actual);
    }

    private Optional<String> getFileExtension(File file) {
        return org.assertj.core.util.Files.getFileNameExtension(file.getName());
    }

    private void verifyIsFile(File expected) {
        java.util.Objects.requireNonNull(expected, "The file to compare to should not be null");
        Preconditions.checkArgument(expected.isFile(), "Expected file:<'%s'> should be an existing file", expected);
    }

    private boolean isAbsolutePath(AssertionInfo info2, File actual) {
        Files.assertNotNull(info2, actual);
        return actual.isAbsolute();
    }
}

