/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class LongArrays {
    private static final LongArrays INSTANCE = new LongArrays();
    private Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static LongArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    LongArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public LongArrays(ComparisonStrategy comparisonStrategy) {
        this.setArrays(new Arrays(comparisonStrategy));
    }

    @VisibleForTesting
    public void setArrays(Arrays arrays) {
        this.arrays = arrays;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public void assertNullOrEmpty(AssertionInfo info2, long[] actual) {
        this.arrays.assertNullOrEmpty(info2, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info2, long[] actual) {
        this.arrays.assertEmpty(info2, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info2, long[] actual) {
        this.arrays.assertNotEmpty(info2, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info2, long[] actual, int expectedSize) {
        this.arrays.assertHasSize(info2, actual, expectedSize);
    }

    public void assertHasSizeGreaterThan(AssertionInfo info2, long[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThan(info2, actual, boundary);
    }

    public void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info2, long[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(info2, actual, boundary);
    }

    public void assertHasSizeLessThan(AssertionInfo info2, long[] actual, int boundary) {
        this.arrays.assertHasSizeLessThan(info2, actual, boundary);
    }

    public void assertHasSizeLessThanOrEqualTo(AssertionInfo info2, long[] actual, int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(info2, actual, boundary);
    }

    public void assertHasSizeBetween(AssertionInfo info2, long[] actual, int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(info2, actual, lowerBoundary, higherBoundary);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, long[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info2, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, long[] actual, Object[] other) {
        this.arrays.assertHasSameSizeAs(info2, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info2, long[] actual, long[] values) {
        this.arrays.assertContains(info2, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info2, long[] actual, long value, Index index) {
        this.arrays.assertContains(info2, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info2, long[] actual, long value, Index index) {
        this.arrays.assertDoesNotContain(info2, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info2, long[] actual, long[] values) {
        this.arrays.assertContainsOnly(info2, this.failures, actual, values);
    }

    public void assertContainsExactly(AssertionInfo info2, long[] actual, long[] values) {
        this.arrays.assertContainsExactly(info2, this.failures, actual, values);
    }

    public void assertContainsExactlyInAnyOrder(AssertionInfo info2, long[] actual, long[] values) {
        this.arrays.assertContainsExactlyInAnyOrder(info2, this.failures, actual, values);
    }

    public void assertContainsOnlyOnce(AssertionInfo info2, long[] actual, long[] values) {
        this.arrays.assertContainsOnlyOnce(info2, this.failures, actual, values);
    }

    public void assertContainsSequence(AssertionInfo info2, long[] actual, long[] sequence) {
        this.arrays.assertContainsSequence(info2, this.failures, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info2, long[] actual, long[] subsequence) {
        this.arrays.assertContainsSubsequence(info2, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info2, long[] actual, long[] values) {
        this.arrays.assertDoesNotContain(info2, this.failures, actual, values);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info2, long[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info2, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info2, long[] actual, long[] sequence) {
        this.arrays.assertStartsWith(info2, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info2, long[] actual, long[] sequence) {
        this.arrays.assertEndsWith(info2, this.failures, actual, sequence);
    }

    public void assertIsSorted(AssertionInfo info2, long[] actual) {
        this.arrays.assertIsSorted(info2, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info2, long[] actual, Comparator<? super Long> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info2, this.failures, actual, comparator);
    }

    public void assertContainsAnyOf(AssertionInfo info2, long[] actual, long[] values) {
        this.arrays.assertContainsAnyOf(info2, this.failures, actual, values);
    }
}

