/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveAtLeastOneElementOfType;
import org.assertj.core.error.ShouldHaveExactlyTypes;
import org.assertj.core.error.ShouldHaveOnlyElementsOfType;
import org.assertj.core.error.ShouldNotHaveAnyElementsOfTypes;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.IterableDiff;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;

public class ObjectArrays {
    private static final ObjectArrays INSTANCE = new ObjectArrays();
    private Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();

    public static ObjectArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    ObjectArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public ObjectArrays(ComparisonStrategy comparisonStrategy) {
        this.setArrays(new Arrays(comparisonStrategy));
    }

    @VisibleForTesting
    void setArrays(Arrays arrays) {
        this.arrays = arrays;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    @VisibleForTesting
    public ComparisonStrategy getComparisonStrategy() {
        return this.arrays.getComparisonStrategy();
    }

    public void assertNullOrEmpty(AssertionInfo info2, Object[] actual) {
        this.arrays.assertNullOrEmpty(info2, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info2, Object[] actual) {
        this.arrays.assertEmpty(info2, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info2, Object[] actual) {
        this.arrays.assertNotEmpty(info2, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info2, Object[] actual, int expectedSize) {
        this.arrays.assertHasSize(info2, actual, expectedSize);
    }

    public void assertHasSizeGreaterThan(AssertionInfo info2, Object[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThan(info2, actual, boundary);
    }

    public void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info2, Object[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(info2, actual, boundary);
    }

    public void assertHasSizeLessThan(AssertionInfo info2, Object[] actual, int boundary) {
        this.arrays.assertHasSizeLessThan(info2, actual, boundary);
    }

    public void assertHasSizeLessThanOrEqualTo(AssertionInfo info2, Object[] actual, int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(info2, actual, boundary);
    }

    public void assertHasSizeBetween(AssertionInfo info2, Object[] actual, int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(info2, actual, lowerBoundary, higherBoundary);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, Object[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info2, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info2, Object[] actual, Object other) {
        this.arrays.assertHasSameSizeAs(info2, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info2, Object[] actual, Object[] values) {
        this.arrays.assertContains(info2, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info2, Object[] actual, Object value, Index index) {
        this.arrays.assertContains(info2, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info2, Object[] actual, Object value, Index index) {
        this.arrays.assertDoesNotContain(info2, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info2, Object[] actual, Object[] values) {
        this.arrays.assertContainsOnly(info2, this.failures, actual, values);
    }

    public void assertContainsExactly(AssertionInfo info2, Object[] actual, Object[] values) {
        this.arrays.assertContainsExactly(info2, this.failures, actual, values);
    }

    public void assertContainsExactlyInAnyOrder(AssertionInfo info2, Object[] actual, Object[] values) {
        this.arrays.assertContainsExactlyInAnyOrder(info2, this.failures, actual, values);
    }

    public void assertContainsOnlyOnce(AssertionInfo info2, Object[] actual, Object[] values) {
        this.arrays.assertContainsOnlyOnce(info2, this.failures, actual, values);
    }

    public void assertContainsOnlyNulls(AssertionInfo info2, Object[] actual) {
        this.arrays.assertContainsOnlyNulls(info2, this.failures, actual);
    }

    public void assertContainsSequence(AssertionInfo info2, Object[] actual, Object[] sequence) {
        this.arrays.assertContainsSequence(info2, this.failures, actual, sequence);
    }

    public void assertDoesNotContainSequence(AssertionInfo info2, Object[] actual, Object[] sequence) {
        this.arrays.assertDoesNotContainSequence(info2, this.failures, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info2, Object[] actual, Object[] subsequence) {
        this.arrays.assertContainsSubsequence(info2, this.failures, actual, subsequence);
    }

    public void assertDoesNotContainSubsequence(AssertionInfo info2, Object[] actual, Object[] subsequence) {
        this.arrays.assertDoesNotContainSubsequence(info2, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info2, Object[] actual, Object[] values) {
        this.arrays.assertDoesNotContain(info2, this.failures, actual, values);
    }

    public <T> void assertDoesNotContainAnyElementsOf(AssertionInfo info2, Object[] actual, Iterable<? extends T> iterable) {
        CommonValidations.checkIsNotNullAndNotEmpty(iterable);
        ArrayList<T> values = Lists.newArrayList(iterable);
        this.assertDoesNotContain(info2, actual, values.toArray());
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info2, Object[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info2, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info2, Object[] actual, Object[] sequence) {
        this.arrays.assertStartsWith(info2, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info2, Object[] actual, Object first, Object[] rest) {
        this.arrays.assertEndsWith(info2, this.failures, actual, first, rest);
    }

    public void assertEndsWith(AssertionInfo info2, Object[] actual, Object[] sequence) {
        this.arrays.assertEndsWith(info2, this.failures, actual, sequence);
    }

    public void assertIsSubsetOf(AssertionInfo info2, Object actual, Iterable<?> values) {
        this.arrays.assertIsSubsetOf(info2, this.failures, actual, values);
    }

    public void assertContainsNull(AssertionInfo info2, Object[] actual) {
        this.arrays.assertContainsNull(info2, this.failures, actual);
    }

    public void assertDoesNotContainNull(AssertionInfo info2, Object[] actual) {
        this.arrays.assertDoesNotContainNull(info2, this.failures, actual);
    }

    public <E> void assertAre(AssertionInfo info2, E[] actual, Condition<? super E> condition) {
        this.arrays.assertAre(info2, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertAreNot(AssertionInfo info2, E[] actual, Condition<? super E> condition) {
        this.arrays.assertAreNot(info2, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertHave(AssertionInfo info2, E[] actual, Condition<? super E> condition) {
        this.arrays.assertHave(info2, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertDoNotHave(AssertionInfo info2, E[] actual, Condition<? super E> condition) {
        this.arrays.assertHaveNot(info2, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertAreAtLeast(AssertionInfo info2, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreAtLeast(info2, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertAreAtMost(AssertionInfo info2, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreAtMost(info2, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertAreExactly(AssertionInfo info2, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreExactly(info2, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertHaveAtLeast(AssertionInfo info2, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveAtLeast(info2, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHaveAtMost(AssertionInfo info2, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveAtMost(info2, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHaveExactly(AssertionInfo info2, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveExactly(info2, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHasAtLeastOneElementOfType(AssertionInfo info2, E[] actual, Class<?> type) {
        Objects.instance().assertNotNull(info2, actual);
        boolean found = false;
        for (E o : actual) {
            if (!type.isInstance(o)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw this.failures.failure(info2, ShouldHaveAtLeastOneElementOfType.shouldHaveAtLeastOneElementOfType(actual, type));
        }
    }

    public <E> void assertHasOnlyElementsOfType(AssertionInfo info2, E[] actual, Class<?> type) {
        Objects.instance().assertNotNull(info2, actual);
        for (E element : actual) {
            if (type.isInstance(element)) continue;
            throw this.failures.failure(info2, ShouldHaveOnlyElementsOfType.shouldHaveOnlyElementsOfType(actual, type, element == null ? null : element.getClass()));
        }
    }

    public <E> void assertHasOnlyElementsOfTypes(AssertionInfo info2, E[] actual, Class<?> ... types) {
        this.arrays.assertHasOnlyElementsOfTypes(info2, this.failures, actual, types);
    }

    public <E> void assertHasExactlyElementsOfTypes(AssertionInfo info2, E[] actual, Class<?> ... expectedTypes) {
        Objects.instance().assertNotNull(info2, actual);
        List actualTypeList = Stream.of(actual).map(Object::getClass).collect(Collectors.toList());
        IterableDiff<Class<?>> typesDiff = IterableDiff.diff(actualTypeList, Lists.list(expectedTypes));
        if (typesDiff.differencesFound()) {
            throw this.failures.failure(info2, ShouldHaveExactlyTypes.shouldHaveTypes(actual, Lists.list(expectedTypes), typesDiff.missing, typesDiff.unexpected));
        }
        int i2 = 0;
        for (E actualElement : actual) {
            if (!java.util.Objects.equals(actualElement.getClass(), expectedTypes[i2])) {
                throw this.failures.failure(info2, ShouldHaveExactlyTypes.elementsTypesDifferAtIndex(actualElement, expectedTypes[i2], i2));
            }
            ++i2;
        }
    }

    public <E> void assertDoesNotHaveAnyElementsOfTypes(AssertionInfo info2, E[] actual, Class<?> ... unexpectedTypes) {
        Objects.instance().assertNotNull(info2, actual);
        LinkedHashMap nonMatchingElementsByType = new LinkedHashMap();
        for (E element : actual) {
            for (Class<?> type : unexpectedTypes) {
                if (!type.isInstance(element)) continue;
                if (!nonMatchingElementsByType.containsKey(type)) {
                    nonMatchingElementsByType.put(type, new ArrayList());
                }
                ((List)nonMatchingElementsByType.get(type)).add(element);
            }
        }
        if (!nonMatchingElementsByType.isEmpty()) {
            throw this.failures.failure(info2, ShouldNotHaveAnyElementsOfTypes.shouldNotHaveAnyElementsOfTypes(actual, unexpectedTypes, nonMatchingElementsByType));
        }
    }

    public void assertIsSorted(AssertionInfo info2, Object[] actual) {
        this.arrays.assertIsSorted(info2, this.failures, actual);
    }

    public <E> void assertIsSortedAccordingToComparator(AssertionInfo info2, E[] actual, Comparator<? super E> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info2, this.failures, actual, comparator);
    }

    public <E> void assertContainsAll(AssertionInfo info2, E[] actual, Iterable<? extends E> other) {
        this.arrays.assertcontainsAll(info2, this.failures, actual, other);
    }

    public void assertContainsAnyOf(AssertionInfo info2, Object[] actual, Object[] values) {
        this.arrays.assertContainsAnyOf(info2, this.failures, actual, values);
    }
}

