/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.GroupTypeDescription;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeEqualByComparingFieldByFieldRecursively;
import org.assertj.core.error.ShouldBeEqualByComparingOnlyGivenFields;
import org.assertj.core.error.ShouldBeEqualToIgnoringFields;
import org.assertj.core.error.ShouldBeExactlyInstanceOf;
import org.assertj.core.error.ShouldBeIn;
import org.assertj.core.error.ShouldBeInstance;
import org.assertj.core.error.ShouldBeInstanceOfAny;
import org.assertj.core.error.ShouldBeOfClassIn;
import org.assertj.core.error.ShouldBeSame;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldHaveAllNullFields;
import org.assertj.core.error.ShouldHaveNoNullFields;
import org.assertj.core.error.ShouldHavePropertyOrField;
import org.assertj.core.error.ShouldHavePropertyOrFieldWithValue;
import org.assertj.core.error.ShouldHaveSameClass;
import org.assertj.core.error.ShouldHaveSameHashCode;
import org.assertj.core.error.ShouldHaveToString;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.error.ShouldNotBeExactlyInstanceOf;
import org.assertj.core.error.ShouldNotBeIn;
import org.assertj.core.error.ShouldNotBeInstance;
import org.assertj.core.error.ShouldNotBeInstanceOfAny;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.ShouldNotBeOfClassIn;
import org.assertj.core.error.ShouldNotBeSame;
import org.assertj.core.error.ShouldNotHaveSameClass;
import org.assertj.core.error.ShouldNotHaveSameHashCode;
import org.assertj.core.error.ShouldNotHaveToString;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.DeepDifference;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Sets;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.FieldSupport;
import org.assertj.core.util.introspection.IntrospectionError;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;
import org.assertj.core.util.introspection.PropertySupport;

public class Objects {
    private static final Objects INSTANCE = new Objects();
    private static final GroupTypeDescription FIELDS_GROUP_DESCRIPTION = new GroupTypeDescription("non static/synthetic fields of", "fields");
    @VisibleForTesting
    final PropertySupport propertySupport = PropertySupport.instance();
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();
    private final FieldSupport fieldSupport = FieldSupport.comparison();

    public static Objects instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Objects() {
        this(StandardComparisonStrategy.instance());
    }

    public Objects(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy ? ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator() : null;
    }

    public ComparisonStrategy getComparisonStrategy() {
        return this.comparisonStrategy;
    }

    public Failures getFailures() {
        return this.failures;
    }

    public void assertIsInstanceOf(AssertionInfo info2, Object actual, Class<?> type) {
        if (!this.isInstanceOfClass(actual, type, info2)) {
            throw this.failures.failure(info2, ShouldBeInstance.shouldBeInstance(actual, type));
        }
    }

    public void assertIsInstanceOfAny(AssertionInfo info2, Object actual, Class<?>[] types) {
        if (this.objectIsInstanceOfOneOfGivenClasses(actual, types, info2)) {
            return;
        }
        throw this.failures.failure(info2, ShouldBeInstanceOfAny.shouldBeInstanceOfAny(actual, types));
    }

    private boolean objectIsInstanceOfOneOfGivenClasses(Object actual, Class<?>[] types, AssertionInfo info2) {
        this.checkIsNotNullAndIsNotEmpty(types);
        this.assertNotNull(info2, actual);
        for (Class<?> type : types) {
            String format = "The given array of types:<%s> should not have null elements";
            java.util.Objects.requireNonNull(type, String.format(format, info2.representation().toStringOf(types)));
            if (!type.isInstance(actual)) continue;
            return true;
        }
        return false;
    }

    public void assertIsNotInstanceOf(AssertionInfo info2, Object actual, Class<?> type) {
        if (this.isInstanceOfClass(actual, type, info2)) {
            throw this.failures.failure(info2, ShouldNotBeInstance.shouldNotBeInstance(actual, type));
        }
    }

    private boolean isInstanceOfClass(Object actual, Class<?> clazz, AssertionInfo info2) {
        this.assertNotNull(info2, actual);
        CommonValidations.checkTypeIsNotNull(clazz);
        return clazz.isInstance(actual);
    }

    public void assertIsNotInstanceOfAny(AssertionInfo info2, Object actual, Class<?>[] types) {
        if (!this.objectIsInstanceOfOneOfGivenClasses(actual, types, info2)) {
            return;
        }
        throw this.failures.failure(info2, ShouldNotBeInstanceOfAny.shouldNotBeInstanceOfAny(actual, types));
    }

    public void assertHasSameClassAs(AssertionInfo info2, Object actual, Object other) {
        if (!this.haveSameClass(actual, other, info2)) {
            throw this.failures.failure(info2, ShouldHaveSameClass.shouldHaveSameClass(actual, other));
        }
    }

    private boolean haveSameClass(Object actual, Object other, AssertionInfo info2) {
        this.assertNotNull(info2, actual);
        java.util.Objects.requireNonNull(other, "The given object should not be null");
        Class<?> actualClass = actual.getClass();
        Class<?> otherClass = other.getClass();
        return actualClass.equals(otherClass);
    }

    public void assertDoesNotHaveSameClassAs(AssertionInfo info2, Object actual, Object other) {
        if (this.haveSameClass(actual, other, info2)) {
            throw this.failures.failure(info2, ShouldNotHaveSameClass.shouldNotHaveSameClass(actual, other));
        }
    }

    public void assertIsExactlyInstanceOf(AssertionInfo info2, Object actual, Class<?> type) {
        if (!this.actualIsExactlyInstanceOfType(actual, type, info2)) {
            throw this.failures.failure(info2, ShouldBeExactlyInstanceOf.shouldBeExactlyInstance(actual, type));
        }
    }

    private boolean actualIsExactlyInstanceOfType(Object actual, Class<?> expectedType, AssertionInfo info2) {
        this.assertNotNull(info2, actual);
        CommonValidations.checkTypeIsNotNull(expectedType);
        return expectedType.equals(actual.getClass());
    }

    public void assertIsNotExactlyInstanceOf(AssertionInfo info2, Object actual, Class<?> type) {
        if (this.actualIsExactlyInstanceOfType(actual, type, info2)) {
            throw this.failures.failure(info2, ShouldNotBeExactlyInstanceOf.shouldNotBeExactlyInstance(actual, type));
        }
    }

    public void assertIsOfAnyClassIn(AssertionInfo info2, Object actual, Class<?>[] types) {
        boolean itemInArray = this.isOfOneOfGivenTypes(actual, types, info2);
        if (!itemInArray) {
            throw this.failures.failure(info2, ShouldBeOfClassIn.shouldBeOfClassIn(actual, types));
        }
    }

    private boolean isOfOneOfGivenTypes(Object actual, Class<?>[] types, AssertionInfo info2) {
        this.assertNotNull(info2, actual);
        java.util.Objects.requireNonNull(types, "The given types should not be null");
        return this.isItemInArray(actual.getClass(), types);
    }

    public void assertIsNotOfAnyClassIn(AssertionInfo info2, Object actual, Class<?>[] types) {
        boolean itemInArray = this.isOfOneOfGivenTypes(actual, types, info2);
        if (itemInArray) {
            throw this.failures.failure(info2, ShouldNotBeOfClassIn.shouldNotBeOfClassIn(actual, types));
        }
    }

    private void checkIsNotNullAndIsNotEmpty(Class<?>[] types) {
        java.util.Objects.requireNonNull(types, "The given array of types should not be null");
        Preconditions.checkArgument(types.length > 0, "The given array of types should not be empty", new Object[0]);
    }

    public void assertEqual(AssertionInfo info2, Object actual, Object expected) {
        if (!this.areEqual(actual, expected)) {
            throw this.failures.failure(info2, ShouldBeEqual.shouldBeEqual(actual, expected, this.comparisonStrategy, info2.representation()));
        }
    }

    public void assertNotEqual(AssertionInfo info2, Object actual, Object other) {
        if (this.areEqual(actual, other)) {
            throw this.failures.failure(info2, ShouldNotBeEqual.shouldNotBeEqual(actual, other, this.comparisonStrategy));
        }
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    public void assertNull(AssertionInfo info2, Object actual) {
        if (actual != null) {
            throw this.failures.failure(info2, ShouldBeEqual.shouldBeEqual(actual, null, this.comparisonStrategy, info2.representation()));
        }
    }

    public void assertNotNull(AssertionInfo info2, Object actual) {
        if (actual == null) {
            throw this.failures.failure(info2, ShouldNotBeNull.shouldNotBeNull());
        }
    }

    public void assertNotNull(AssertionInfo info2, Object actual, String label) {
        if (actual == null) {
            throw this.failures.failure(info2, ShouldNotBeNull.shouldNotBeNull(label));
        }
    }

    public void assertSame(AssertionInfo info2, Object actual, Object expected) {
        if (actual != expected) {
            throw this.failures.failure(info2, ShouldBeSame.shouldBeSame(actual, expected));
        }
    }

    public void assertNotSame(AssertionInfo info2, Object actual, Object other) {
        if (actual == other) {
            throw this.failures.failure(info2, ShouldNotBeSame.shouldNotBeSame(actual));
        }
    }

    public void assertHasToString(AssertionInfo info2, Object actual, String expectedToString) {
        this.assertNotNull(info2, actual);
        String actualString = actual.toString();
        if (!actualString.equals(expectedToString)) {
            throw this.failures.failure(info2, ShouldHaveToString.shouldHaveToString(actualString, expectedToString), actualString, expectedToString);
        }
    }

    public void assertDoesNotHaveToString(AssertionInfo info2, Object actual, String otherToString) {
        this.assertNotNull(info2, actual);
        String actualToString = actual.toString();
        if (actualToString.equals(otherToString)) {
            throw this.failures.failure(info2, ShouldNotHaveToString.shouldNotHaveToString(otherToString));
        }
    }

    public void assertIsIn(AssertionInfo info2, Object actual, Object[] values) {
        this.checkArrayIsNotNull(values);
        this.assertIsIn(info2, actual, Arrays.asList(values));
    }

    public void assertIsNotIn(AssertionInfo info2, Object actual, Object[] values) {
        this.checkArrayIsNotNull(values);
        this.assertIsNotIn(info2, actual, Arrays.asList(values));
    }

    private void checkArrayIsNotNull(Object[] values) {
        java.util.Objects.requireNonNull(values, "The given array should not be null");
    }

    private boolean isItemInArray(Object item, Object[] arrayOfValues) {
        for (Object value : arrayOfValues) {
            if (!this.areEqual(value, item)) continue;
            return true;
        }
        return false;
    }

    public void assertIsIn(AssertionInfo info2, Object actual, Iterable<?> values) {
        this.checkNotNullIterable(values);
        if (!this.isActualIn(actual, values)) {
            throw this.failures.failure(info2, ShouldBeIn.shouldBeIn(actual, values, this.comparisonStrategy));
        }
    }

    public void assertIsNotIn(AssertionInfo info2, Object actual, Iterable<?> values) {
        this.checkNotNullIterable(values);
        if (this.isActualIn(actual, values)) {
            throw this.failures.failure(info2, ShouldNotBeIn.shouldNotBeIn(actual, values, this.comparisonStrategy));
        }
    }

    private void checkNotNullIterable(Iterable<?> values) {
        java.util.Objects.requireNonNull(values, "The given iterable should not be null");
    }

    private boolean isActualIn(Object actual, Iterable<?> values) {
        for (Object value : values) {
            if (!this.areEqual(actual, value)) continue;
            return true;
        }
        return false;
    }

    public <A> void assertIsEqualToIgnoringNullFields(AssertionInfo info2, A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        this.assertNotNull(info2, actual);
        LinkedList<String> fieldsNames = new LinkedList<String>();
        LinkedList<Object> rejectedValues = new LinkedList<Object>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedList<String> nullFields = new LinkedList<String>();
        for (Field field : Objects.getDeclaredFieldsIncludingInherited(actual.getClass())) {
            if (!this.canReadFieldValue(field, actual)) continue;
            String fieldName = field.getName();
            Object otherFieldValue = this.getPropertyOrFieldValue(other, fieldName);
            if (otherFieldValue == null) {
                nullFields.add(fieldName);
                continue;
            }
            Object actualFieldValue = this.getPropertyOrFieldValue(actual, fieldName);
            if (Objects.propertyOrFieldValuesAreEqual(actualFieldValue, otherFieldValue, fieldName, comparatorByPropertyOrField, comparatorByType)) continue;
            fieldsNames.add(fieldName);
            rejectedValues.add(actualFieldValue);
            expectedValues.add(otherFieldValue);
        }
        if (!fieldsNames.isEmpty()) {
            throw this.failures.failure(info2, ShouldBeEqualToIgnoringFields.shouldBeEqualToIgnoringGivenFields(actual, fieldsNames, rejectedValues, expectedValues, nullFields));
        }
    }

    public <A> void assertIsEqualToComparingOnlyGivenFields(AssertionInfo info2, A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String ... fields) {
        this.assertNotNull(info2, actual);
        ByFieldsComparison byFieldsComparison = this.isEqualToComparingOnlyGivenFields(actual, other, comparatorByPropertyOrField, comparatorByType, fields);
        if (byFieldsComparison.isFieldsNamesNotEmpty()) {
            throw this.failures.failure(info2, ShouldBeEqualByComparingOnlyGivenFields.shouldBeEqualComparingOnlyGivenFields(actual, byFieldsComparison.fieldsNames, byFieldsComparison.rejectedValues, byFieldsComparison.expectedValues, Lists.newArrayList(fields)));
        }
    }

    private <A> ByFieldsComparison isEqualToComparingOnlyGivenFields(A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String[] fields) {
        LinkedList<String> rejectedFieldsNames = new LinkedList<String>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedList<Object> rejectedValues = new LinkedList<Object>();
        for (String fieldName : fields) {
            Object otherFieldValue;
            Object actualFieldValue = this.getPropertyOrFieldValue(actual, fieldName);
            if (Objects.propertyOrFieldValuesAreEqual(actualFieldValue, otherFieldValue = this.getPropertyOrFieldValue(other, fieldName), fieldName, comparatorByPropertyOrField, comparatorByType)) continue;
            rejectedFieldsNames.add(fieldName);
            expectedValues.add(otherFieldValue);
            rejectedValues.add(actualFieldValue);
        }
        return new ByFieldsComparison(rejectedFieldsNames, expectedValues, rejectedValues);
    }

    public <A> void assertIsEqualToIgnoringGivenFields(AssertionInfo info2, A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String ... fields) {
        this.assertNotNull(info2, actual);
        ByFieldsComparison byFieldsComparison = this.isEqualToIgnoringGivenFields(actual, other, comparatorByPropertyOrField, comparatorByType, fields);
        if (byFieldsComparison.isFieldsNamesNotEmpty()) {
            throw this.failures.failure(info2, ShouldBeEqualToIgnoringFields.shouldBeEqualToIgnoringGivenFields(actual, byFieldsComparison.fieldsNames, byFieldsComparison.rejectedValues, byFieldsComparison.expectedValues, Lists.newArrayList(fields)));
        }
    }

    private <A> ByFieldsComparison isEqualToIgnoringGivenFields(A actual, A other, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String[] givenIgnoredFields) {
        Set<Field> declaredFieldsIncludingInherited = Objects.getDeclaredFieldsIncludingInherited(actual.getClass());
        LinkedList<String> fieldsNames = new LinkedList<String>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedList<Object> rejectedValues = new LinkedList<Object>();
        LinkedHashSet<String> ignoredFields = Sets.newLinkedHashSet(givenIgnoredFields);
        for (Field field : declaredFieldsIncludingInherited) {
            Object otherFieldValue;
            Object actualFieldValue;
            String fieldName = field.getName();
            if (ignoredFields.contains(fieldName) || !this.canReadFieldValue(field, actual) || Objects.propertyOrFieldValuesAreEqual(actualFieldValue = this.getPropertyOrFieldValue(actual, fieldName), otherFieldValue = this.getPropertyOrFieldValue(other, fieldName), fieldName, comparatorByPropertyOrField, comparatorByType)) continue;
            fieldsNames.add(fieldName);
            rejectedValues.add(actualFieldValue);
            expectedValues.add(otherFieldValue);
        }
        return new ByFieldsComparison(fieldsNames, expectedValues, rejectedValues);
    }

    static boolean propertyOrFieldValuesAreEqual(Object actualFieldValue, Object otherFieldValue, String fieldName, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        if (actualFieldValue == otherFieldValue) {
            return true;
        }
        Comparator<?> fieldComparator = comparatorByPropertyOrField.get(fieldName);
        if (fieldComparator != null) {
            return fieldComparator.compare(actualFieldValue, otherFieldValue) == 0;
        }
        Class<?> fieldType = actualFieldValue != null ? actualFieldValue.getClass() : otherFieldValue.getClass();
        Comparator<?> typeComparator = comparatorByType.getComparatorForType(fieldType);
        if (typeComparator != null) {
            return typeComparator.compare(actualFieldValue, otherFieldValue) == 0;
        }
        return java.util.Objects.deepEquals(actualFieldValue, otherFieldValue);
    }

    private <A> boolean canReadFieldValue(Field field, A actual) {
        return this.fieldSupport.isAllowedToRead(field) || this.propertySupport.publicGetterExistsFor(field.getName(), actual);
    }

    public <A> void assertHasNoNullFieldsOrPropertiesExcept(AssertionInfo info2, A actual, String ... propertiesOrFieldsToIgnore) {
        this.assertNotNull(info2, actual);
        Set<Field> declaredFieldsIncludingInherited = Objects.getDeclaredFieldsIncludingInherited(actual.getClass());
        LinkedList<String> nullFieldNames = new LinkedList<String>();
        LinkedHashSet<String> ignoredFields = Sets.newLinkedHashSet(propertiesOrFieldsToIgnore);
        for (Field field : declaredFieldsIncludingInherited) {
            Object actualFieldValue;
            String fieldName = field.getName();
            if (ignoredFields.contains(fieldName) || !this.canReadFieldValue(field, actual) || (actualFieldValue = this.getPropertyOrFieldValue(actual, fieldName)) != null) continue;
            nullFieldNames.add(fieldName);
        }
        if (!nullFieldNames.isEmpty()) {
            throw this.failures.failure(info2, ShouldHaveNoNullFields.shouldHaveNoNullFieldsExcept(actual, nullFieldNames, Lists.newArrayList(propertiesOrFieldsToIgnore)));
        }
    }

    public <A> void assertHasAllNullFieldsOrPropertiesExcept(AssertionInfo info2, A actual, String ... propertiesOrFieldsToIgnore) {
        this.assertNotNull(info2, actual);
        Set<Field> declaredFields = Objects.getDeclaredFieldsIncludingInherited(actual.getClass());
        LinkedHashSet<String> ignoredFields = Sets.newLinkedHashSet(propertiesOrFieldsToIgnore);
        List<String> nonNullFieldNames = declaredFields.stream().filter(field -> !ignoredFields.contains(field.getName())).filter(field -> this.canReadFieldValue((Field)field, actual)).filter(field -> this.getPropertyOrFieldValue(actual, field.getName()) != null).map(Field::getName).collect(Collectors.toList());
        if (!nonNullFieldNames.isEmpty()) {
            throw this.failures.failure(info2, ShouldHaveAllNullFields.shouldHaveAllNullFields(actual, nonNullFieldNames, Lists.list(propertiesOrFieldsToIgnore)));
        }
    }

    public <A> void assertIsEqualToComparingFieldByFieldRecursively(AssertionInfo info2, Object actual, Object other, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType) {
        this.assertNotNull(info2, actual);
        List<DeepDifference.Difference> differences = DeepDifference.determineDifferences(actual, other, comparatorByPropertyOrField, comparatorByType);
        if (!differences.isEmpty()) {
            throw this.failures.failure(info2, ShouldBeEqualByComparingFieldByFieldRecursively.shouldBeEqualByComparingFieldByFieldRecursive(actual, other, differences, info2.representation()));
        }
    }

    private <A> Object getPropertyOrFieldValue(A a, String fieldName) {
        return PropertyOrFieldSupport.COMPARISON.getValueOf(fieldName, a);
    }

    public static Set<Field> getDeclaredFieldsIncludingInherited(Class<?> clazz) {
        java.util.Objects.requireNonNull(clazz, "expecting Class parameter not to be null");
        Set<Field> declaredFields = Objects.getDeclaredFieldsIgnoringSyntheticAndStatic(clazz);
        for (Class<?> superclazz = clazz.getSuperclass(); superclazz != null && !superclazz.getName().startsWith("java.lang"); superclazz = superclazz.getSuperclass()) {
            declaredFields.addAll(Objects.getDeclaredFieldsIgnoringSyntheticAndStatic(superclazz));
        }
        return declaredFields;
    }

    public static Set<String> getFieldsNames(Class<?> clazz) {
        return Objects.getDeclaredFieldsIncludingInherited(clazz).stream().map(Field::getName).collect(Collectors.toSet());
    }

    private static Set<Field> getDeclaredFieldsIgnoringSyntheticAndStatic(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> !field.isSynthetic() && !Modifier.isStatic(field.getModifiers())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean areEqualToIgnoringGivenFields(Object actual, Object other, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String ... fields) {
        return this.isEqualToIgnoringGivenFields(actual, other, comparatorByPropertyOrField, comparatorByType, fields).isFieldsNamesEmpty();
    }

    public boolean areEqualToComparingOnlyGivenFields(Object actual, Object other, Map<String, Comparator<?>> comparatorByPropertyOrField, TypeComparators comparatorByType, String ... fields) {
        return this.isEqualToComparingOnlyGivenFields(actual, other, comparatorByPropertyOrField, comparatorByType, fields).isFieldsNamesEmpty();
    }

    public <A> void assertHasFieldOrProperty(AssertionInfo info2, A actual, String name) {
        this.assertNotNull(info2, actual);
        try {
            this.extractPropertyOrField(actual, name);
        }
        catch (IntrospectionError error) {
            throw this.failures.failure(info2, ShouldHavePropertyOrField.shouldHavePropertyOrField(actual, name));
        }
    }

    public <A> void assertHasFieldOrPropertyWithValue(AssertionInfo info2, A actual, String name, Object expectedValue) {
        this.assertHasFieldOrProperty(info2, actual, name);
        Object value = this.extractPropertyOrField(actual, name);
        if (!java.util.Objects.deepEquals(value, expectedValue)) {
            throw this.failures.failure(info2, ShouldHavePropertyOrFieldWithValue.shouldHavePropertyOrFieldWithValue(actual, name, expectedValue, value));
        }
    }

    public <A> void assertHasOnlyFields(AssertionInfo info2, A actual, String ... names) {
        this.assertNotNull(info2, actual);
        Preconditions.checkArgument(names != null, "Given fields/properties are null", new Object[0]);
        List expectedFields = Arrays.stream(names).sorted().collect(Collectors.toList());
        Field[] declaredFields = actual.getClass().getDeclaredFields();
        List actualFields = Arrays.stream(declaredFields).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !field.isSynthetic()).map(Field::getName).sorted().collect(Collectors.toList());
        if (!expectedFields.equals(actualFields)) {
            List fieldsNotFound = Arrays.stream(names).filter(name -> !actualFields.contains(name)).collect(Collectors.toList());
            List extraFields = actualFields.stream().filter(actualField -> !expectedFields.contains(actualField)).collect(Collectors.toList());
            throw this.failures.failure(info2, ShouldContainOnly.shouldContainOnly(actual, (Object)names, fieldsNotFound, extraFields, FIELDS_GROUP_DESCRIPTION));
        }
    }

    private <A> Object extractPropertyOrField(A actual, String name) {
        return PropertyOrFieldSupport.EXTRACTION.getValueOf(name, actual);
    }

    public <A> void assertHasSameHashCodeAs(AssertionInfo info2, A actual, Object other) {
        this.assertNotNull(info2, actual);
        java.util.Objects.requireNonNull(other, "The object used to compare actual's hash code with should not be null");
        if (actual.hashCode() != other.hashCode()) {
            throw this.failures.failure(info2, ShouldHaveSameHashCode.shouldHaveSameHashCode(actual, other));
        }
    }

    public <A> void assertDoesNotHaveSameHashCodeAs(AssertionInfo info2, A actual, Object other) {
        this.assertNotNull(info2, actual);
        java.util.Objects.requireNonNull(other, "The object used to compare actual's hash code with should not be null");
        if (actual.hashCode() == other.hashCode()) {
            throw this.failures.failure(info2, ShouldNotHaveSameHashCode.shouldNotHaveSameHashCode(actual, other));
        }
    }

    public static class ByFieldsComparison {
        private final List<String> fieldsNames;
        private final List<Object> expectedValues;
        private final List<Object> rejectedValues;

        public ByFieldsComparison(List<String> fieldsNames, List<Object> expectedValues, List<Object> rejectedValues) {
            this.fieldsNames = fieldsNames;
            this.expectedValues = expectedValues;
            this.rejectedValues = rejectedValues;
        }

        public ByFieldsComparison() {
            this(new ArrayList<String>(), new ArrayList<Object>(), new ArrayList<Object>());
        }

        public boolean isFieldsNamesEmpty() {
            return this.fieldsNames.isEmpty();
        }

        public boolean isFieldsNamesNotEmpty() {
            return !this.isFieldsNamesEmpty();
        }
    }
}

