/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.engine.config.CachingJupiterConfiguration;
import org.junit.jupiter.engine.config.DefaultJupiterConfiguration;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.DiscoverySelectorResolver;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.support.JupiterThrowableCollectorFactory;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.config.PrefixedConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.ForkJoinPoolHierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.INTERNAL, since="5.0")
public final class JupiterTestEngine
extends HierarchicalTestEngine<JupiterEngineExecutionContext> {
    @Override
    public String getId() {
        return "junit-jupiter";
    }

    @Override
    public Optional<String> getGroupId() {
        return Optional.of("org.junit.jupiter");
    }

    @Override
    public Optional<String> getArtifactId() {
        return Optional.of("junit-jupiter-engine");
    }

    @Override
    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        CachingJupiterConfiguration configuration = new CachingJupiterConfiguration(new DefaultJupiterConfiguration(discoveryRequest.getConfigurationParameters()));
        JupiterEngineDescriptor engineDescriptor = new JupiterEngineDescriptor(uniqueId, configuration);
        new DiscoverySelectorResolver().resolveSelectors(discoveryRequest, engineDescriptor);
        return engineDescriptor;
    }

    @Override
    protected HierarchicalTestExecutorService createExecutorService(ExecutionRequest request2) {
        JupiterConfiguration configuration = this.getJupiterConfiguration(request2);
        if (configuration.isParallelExecutionEnabled()) {
            return new ForkJoinPoolHierarchicalTestExecutorService(new PrefixedConfigurationParameters(request2.getConfigurationParameters(), "junit.jupiter.execution.parallel.config."));
        }
        return super.createExecutorService(request2);
    }

    @Override
    protected JupiterEngineExecutionContext createExecutionContext(ExecutionRequest request2) {
        return new JupiterEngineExecutionContext(request2.getEngineExecutionListener(), this.getJupiterConfiguration(request2));
    }

    @Override
    protected ThrowableCollector.Factory createThrowableCollectorFactory(ExecutionRequest request2) {
        return JupiterThrowableCollectorFactory::createThrowableCollector;
    }

    private JupiterConfiguration getJupiterConfiguration(ExecutionRequest request2) {
        JupiterEngineDescriptor engineDescriptor = (JupiterEngineDescriptor)request2.getRootTestDescriptor();
        return engineDescriptor.getConfiguration();
    }
}

