/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> T getOnlyElement(Collection<T> collection) {
        Preconditions.notNull(collection, "collection must not be null");
        Preconditions.condition(collection.size() == 1, () -> "collection must contain exactly one element: " + collection);
        return collection.iterator().next();
    }

    @API(status=API.Status.INTERNAL, since="1.6")
    public static <T> Set<T> toSet(T[] values) {
        Preconditions.notNull(values, "values array must not be null");
        if (values.length == 0) {
            return Collections.emptySet();
        }
        if (values.length == 1) {
            return Collections.singleton(values[0]);
        }
        HashSet set2 = new HashSet();
        Collections.addAll(set2, values);
        return set2;
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    @API(status=API.Status.INTERNAL, since="1.9.1")
    public static boolean isConvertibleToStream(Class<?> type) {
        if (type == null || type == Void.TYPE) {
            return false;
        }
        return Stream.class.isAssignableFrom(type) || DoubleStream.class.isAssignableFrom(type) || IntStream.class.isAssignableFrom(type) || LongStream.class.isAssignableFrom(type) || Iterable.class.isAssignableFrom(type) || Iterator.class.isAssignableFrom(type) || Object[].class.isAssignableFrom(type) || type.isArray() && type.getComponentType().isPrimitive();
    }

    public static Stream<?> toStream(Object object) {
        Preconditions.notNull(object, "Object must not be null");
        if (object instanceof Stream) {
            return (Stream)object;
        }
        if (object instanceof DoubleStream) {
            return ((DoubleStream)object).boxed();
        }
        if (object instanceof IntStream) {
            return ((IntStream)object).boxed();
        }
        if (object instanceof LongStream) {
            return ((LongStream)object).boxed();
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream();
        }
        if (object instanceof Iterable) {
            return StreamSupport.stream(((Iterable)object).spliterator(), false);
        }
        if (object instanceof Iterator) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)object, 16), false);
        }
        if (object instanceof Object[]) {
            return Arrays.stream((Object[])object);
        }
        if (object instanceof double[]) {
            return DoubleStream.of((double[])object).boxed();
        }
        if (object instanceof int[]) {
            return IntStream.of((int[])object).boxed();
        }
        if (object instanceof long[]) {
            return LongStream.of((long[])object).boxed();
        }
        if (object.getClass().isArray() && object.getClass().getComponentType().isPrimitive()) {
            return IntStream.range(0, Array.getLength(object)).mapToObj(i2 -> Array.get(object, i2));
        }
        throw new PreconditionViolationException("Cannot convert instance of " + object.getClass().getName() + " into a Stream: " + object);
    }
}

