/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutor;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.junit.platform.engine.support.hierarchical.SameThreadHierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.MAINTAINED, since="1.0")
public abstract class HierarchicalTestEngine<C extends EngineExecutionContext>
implements TestEngine {
    @Override
    public final void execute(ExecutionRequest request2) {
        try (HierarchicalTestExecutorService executorService = this.createExecutorService(request2);){
            C executionContext = this.createExecutionContext(request2);
            ThrowableCollector.Factory throwableCollectorFactory = this.createThrowableCollectorFactory(request2);
            new HierarchicalTestExecutor<C>(request2, executionContext, executorService, throwableCollectorFactory).execute().get();
        }
        catch (Exception exception) {
            throw new JUnitException("Error executing tests for engine " + this.getId(), exception);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3")
    protected HierarchicalTestExecutorService createExecutorService(ExecutionRequest request2) {
        return new SameThreadHierarchicalTestExecutorService();
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3")
    protected ThrowableCollector.Factory createThrowableCollectorFactory(ExecutionRequest request2) {
        return OpenTest4JAwareThrowableCollector::new;
    }

    protected abstract C createExecutionContext(ExecutionRequest var1);
}

