/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.util.Collection;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.util.MockUtil;
import org.mockito.mock.SerializableMode;
import org.mockito.plugins.MockMaker;

public class MockCreationValidator {
    public void validateType(Class<?> classToMock, String mockMaker) {
        MockMaker.TypeMockability typeMockability = MockUtil.typeMockabilityOf(classToMock, mockMaker);
        if (!typeMockability.mockable()) {
            throw Reporter.cannotMockClass(classToMock, typeMockability.nonMockableReason());
        }
    }

    public void validateExtraInterfaces(Class<?> classToMock, Collection<Class<?>> extraInterfaces) {
        if (extraInterfaces == null) {
            return;
        }
        for (Class<?> i2 : extraInterfaces) {
            if (classToMock != i2) continue;
            throw Reporter.extraInterfacesCannotContainMockedType(classToMock);
        }
    }

    public void validateMockedType(Class<?> classToMock, Object spiedInstance) {
        if (classToMock == null || spiedInstance == null) {
            return;
        }
        if (!classToMock.equals(spiedInstance.getClass())) {
            throw Reporter.mockedTypeIsInconsistentWithSpiedInstanceType(classToMock, spiedInstance);
        }
    }

    public void validateDelegatedInstance(Class<?> classToMock, Object delegatedInstance) {
        if (classToMock == null || delegatedInstance == null) {
            return;
        }
        if (delegatedInstance.getClass().isAssignableFrom(classToMock)) {
            throw Reporter.mockedTypeIsInconsistentWithDelegatedInstanceType(classToMock, delegatedInstance);
        }
    }

    public void validateConstructorUse(boolean usingConstructor, SerializableMode mode) {
        if (usingConstructor && mode == SerializableMode.ACROSS_CLASSLOADERS) {
            throw Reporter.usingConstructorWithFancySerializable(mode);
        }
    }
}

