/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class GenericTypeExtractor {
    public static Class<?> genericTypeOf(Class<?> rootClass, Class<?> targetBaseClass, Class<?> targetBaseInterface) {
        for (Class<?> match = rootClass; match != Object.class; match = match.getSuperclass()) {
            if (match.getSuperclass() == targetBaseClass) {
                return GenericTypeExtractor.extractGeneric(match.getGenericSuperclass());
            }
            Type genericInterface = GenericTypeExtractor.findGenericInterface(match, targetBaseInterface);
            if (genericInterface == null) continue;
            return GenericTypeExtractor.extractGeneric(genericInterface);
        }
        return Object.class;
    }

    private static Type findGenericInterface(Class<?> sourceClass, Class<?> targetBaseInterface) {
        for (int i2 = 0; i2 < sourceClass.getInterfaces().length; ++i2) {
            Class<?> inter = sourceClass.getInterfaces()[i2];
            if (inter == targetBaseInterface) {
                return sourceClass.getGenericInterfaces()[i2];
            }
            Type deeper = GenericTypeExtractor.findGenericInterface(inter, targetBaseInterface);
            if (deeper == null) continue;
            return deeper;
        }
        return null;
    }

    private static Class<?> extractGeneric(Type type) {
        Type[] genericTypes;
        if (type instanceof ParameterizedType && (genericTypes = ((ParameterizedType)type).getActualTypeArguments()).length > 0 && genericTypes[0] instanceof Class) {
            return (Class)genericTypes[0];
        }
        return Object.class;
    }

    private GenericTypeExtractor() {
    }
}

