/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public final class ConfigData {
    private final List<PropertySource<?>> propertySources;
    private final PropertySourceOptions propertySourceOptions;
    public static final ConfigData EMPTY = new ConfigData(Collections.emptySet(), new Option[0]);

    public ConfigData(Collection<? extends PropertySource<?>> propertySources, Option ... options2) {
        this(propertySources, PropertySourceOptions.always(Options.of(options2)));
    }

    public ConfigData(Collection<? extends PropertySource<?>> propertySources, PropertySourceOptions propertySourceOptions) {
        Assert.notNull(propertySources, "PropertySources must not be null");
        Assert.notNull((Object)propertySourceOptions, "PropertySourceOptions must not be null");
        this.propertySources = Collections.unmodifiableList(new ArrayList(propertySources));
        this.propertySourceOptions = propertySourceOptions;
    }

    public List<PropertySource<?>> getPropertySources() {
        return this.propertySources;
    }

    public Options getOptions(PropertySource<?> propertySource) {
        Options options2 = this.propertySourceOptions.get(propertySource);
        return options2 != null ? options2 : Options.NONE;
    }

    public static final class Options {
        public static final Options NONE = new Options(Collections.emptySet());
        private final Set<Option> options;

        private Options(Set<Option> options2) {
            this.options = Collections.unmodifiableSet(options2);
        }

        Set<Option> asSet() {
            return this.options;
        }

        public boolean contains(Option option) {
            return this.options.contains((Object)option);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Options other = (Options)obj;
            return this.options.equals(other.options);
        }

        public int hashCode() {
            return this.options.hashCode();
        }

        public String toString() {
            return this.options.toString();
        }

        public Options without(Option option) {
            return this.copy(options2 -> options2.remove((Object)option));
        }

        public Options with(Option option) {
            return this.copy(options2 -> options2.add(option));
        }

        private Options copy(Consumer<EnumSet<Option>> processor) {
            EnumSet<Option> options2 = EnumSet.noneOf(Option.class);
            options2.addAll(this.options);
            processor.accept(options2);
            return new Options(options2);
        }

        public static Options of(Option ... options2) {
            Assert.notNull((Object)options2, "Options must not be null");
            if (options2.length == 0) {
                return NONE;
            }
            return new Options(EnumSet.copyOf(Arrays.asList(options2)));
        }
    }

    public static enum Option {
        IGNORE_IMPORTS,
        IGNORE_PROFILES,
        PROFILE_SPECIFIC;

    }

    @FunctionalInterface
    public static interface PropertySourceOptions {
        public static final PropertySourceOptions ALWAYS_NONE = new AlwaysPropertySourceOptions(Options.NONE);

        public Options get(PropertySource<?> var1);

        public static PropertySourceOptions always(Option ... options2) {
            return PropertySourceOptions.always(Options.of(options2));
        }

        public static PropertySourceOptions always(Options options2) {
            if (options2 == Options.NONE) {
                return ALWAYS_NONE;
            }
            return new AlwaysPropertySourceOptions(options2);
        }
    }

    private static class AlwaysPropertySourceOptions
    implements PropertySourceOptions {
        private final Options options;

        AlwaysPropertySourceOptions(Options options2) {
            this.options = options2;
        }

        @Override
        public Options get(PropertySource<?> propertySource) {
            return this.options;
        }
    }
}

