/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.jdbc;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.AotDetector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@AutoConfiguration(before={DataSourceAutoConfiguration.class})
public class TestDatabaseAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.test.database", name={"replace"}, havingValue="AUTO_CONFIGURED")
    @ConditionalOnMissingBean
    public DataSource dataSource(Environment environment2) {
        return new EmbeddedDataSourceFactory(environment2).getEmbeddedDatabase();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnProperty(prefix="spring.test.database", name={"replace"}, havingValue="ANY", matchIfMissing=true)
    static EmbeddedDataSourceBeanFactoryPostProcessor embeddedDataSourceBeanFactoryPostProcessor() {
        return new EmbeddedDataSourceBeanFactoryPostProcessor();
    }

    static class EmbeddedDataSourceFactory {
        private final Environment environment;

        EmbeddedDataSourceFactory(Environment environment2) {
            this.environment = environment2;
            if (environment2 instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment2;
                HashMap<String, Object> source = new HashMap<String, Object>();
                source.put("spring.datasource.schema-username", "");
                source.put("spring.sql.init.username", "");
                configurableEnvironment.getPropertySources().addFirst(new MapPropertySource("testDatabase", (Map<String, Object>)source));
            }
        }

        EmbeddedDatabase getEmbeddedDatabase() {
            EmbeddedDatabaseConnection connection = this.environment.getProperty("spring.test.database.connection", EmbeddedDatabaseConnection.class, EmbeddedDatabaseConnection.NONE);
            if (EmbeddedDatabaseConnection.NONE.equals((Object)connection)) {
                connection = EmbeddedDatabaseConnection.get(this.getClass().getClassLoader());
            }
            Assert.state(connection != EmbeddedDatabaseConnection.NONE, "Failed to replace DataSource with an embedded database for tests. If you want an embedded database please put a supported one on the classpath or tune the replace attribute of @AutoConfigureTestDatabase.");
            return new EmbeddedDatabaseBuilder().generateUniqueName(true).setType(connection.getType()).build();
        }
    }

    @Order(value=0x7FFFFFFF)
    static class EmbeddedDataSourceBeanFactoryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final Log logger = LogFactory.getLog(EmbeddedDataSourceBeanFactoryPostProcessor.class);

        EmbeddedDataSourceBeanFactoryPostProcessor() {
        }

        @Override
        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (AotDetector.useGeneratedArtifacts()) {
                return;
            }
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)registry, "Test Database Auto-configuration can only be used with a ConfigurableListableBeanFactory");
            this.process(registry, (ConfigurableListableBeanFactory)((Object)registry));
        }

        @Override
        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        private void process(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
            BeanDefinitionHolder holder = this.getDataSourceBeanDefinition(beanFactory);
            if (holder != null) {
                String beanName = holder.getBeanName();
                boolean primary = holder.getBeanDefinition().isPrimary();
                logger.info("Replacing '" + beanName + "' DataSource bean with " + (primary ? "primary " : "") + "embedded version");
                registry.removeBeanDefinition(beanName);
                registry.registerBeanDefinition(beanName, this.createEmbeddedBeanDefinition(primary));
            }
        }

        private BeanDefinition createEmbeddedBeanDefinition(boolean primary) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(EmbeddedDataSourceFactoryBean.class);
            beanDefinition.setPrimary(primary);
            return beanDefinition;
        }

        private BeanDefinitionHolder getDataSourceBeanDefinition(ConfigurableListableBeanFactory beanFactory) {
            Object[] beanNames = beanFactory.getBeanNamesForType(DataSource.class);
            if (ObjectUtils.isEmpty(beanNames)) {
                logger.warn("No DataSource beans found, embedded version will not be used");
                return null;
            }
            if (beanNames.length == 1) {
                Object beanName = beanNames[0];
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            for (Object beanName : beanNames) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
                if (!beanDefinition.isPrimary()) continue;
                return new BeanDefinitionHolder(beanDefinition, (String)beanName);
            }
            logger.warn("No primary DataSource found, embedded version will not be used");
            return null;
        }
    }

    static class EmbeddedDataSourceFactoryBean
    implements FactoryBean<DataSource>,
    EnvironmentAware,
    InitializingBean {
        private EmbeddedDataSourceFactory factory;
        private EmbeddedDatabase embeddedDatabase;

        EmbeddedDataSourceFactoryBean() {
        }

        @Override
        public void setEnvironment(Environment environment2) {
            this.factory = new EmbeddedDataSourceFactory(environment2);
        }

        @Override
        public void afterPropertiesSet() throws Exception {
            this.embeddedDatabase = this.factory.getEmbeddedDatabase();
        }

        @Override
        public DataSource getObject() throws Exception {
            return this.embeddedDatabase;
        }

        @Override
        public Class<?> getObjectType() {
            return EmbeddedDatabase.class;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }
    }
}

