/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.ConverterBuilder;
import org.springframework.data.convert.JMoleculesConverters;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.CustomCollections;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.Streamable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CustomConversions {
    private static final Log logger = LogFactory.getLog(CustomConversions.class);
    private static final String READ_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as reading converter although it doesn't convert from a store-supported type; You might want to check your annotation setup at the converter implementation";
    private static final String WRITE_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as writing converter although it doesn't convert to a store-supported type; You might want to check your annotation setup at the converter implementation";
    private static final String NOT_A_CONVERTER = "Converter %s is neither a Spring Converter, GenericConverter or ConverterFactory";
    private static final String CONVERTER_FILTER = "converter from %s to %s as %s converter";
    private static final String ADD_CONVERTER = "Adding %sconverter from %s to %s as %s converter";
    private static final String SKIP_CONVERTER = "Skipping converter from %s to %s as %s converter %s is not a store supported simple type";
    private static final List<Object> DEFAULT_CONVERTERS;
    private final SimpleTypeHolder simpleTypeHolder;
    private final List<Object> converters;
    private final Set<GenericConverter.ConvertiblePair> readingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
    private final Set<GenericConverter.ConvertiblePair> writingPairs = new LinkedHashSet<GenericConverter.ConvertiblePair>();
    private final Set<Class<?>> customSimpleTypes = new HashSet();
    private final ConversionTargetsCache customReadTargetTypes = new ConversionTargetsCache();
    private final ConversionTargetsCache customWriteTargetTypes = new ConversionTargetsCache();
    private final ConverterConfiguration converterConfiguration;
    private final Function<GenericConverter.ConvertiblePair, Class<?>> getReadTarget = convertiblePair -> this.getCustomTarget(convertiblePair.getSourceType(), convertiblePair.getTargetType(), this.readingPairs);
    private final Function<GenericConverter.ConvertiblePair, Class<?>> getWriteTarget = convertiblePair -> this.getCustomTarget(convertiblePair.getSourceType(), convertiblePair.getTargetType(), this.writingPairs);
    private final Function<GenericConverter.ConvertiblePair, Class<?>> getRawWriteTarget = convertiblePair -> this.getCustomTarget(convertiblePair.getSourceType(), null, this.writingPairs);
    @Nullable
    private final PropertyValueConversions propertyValueConversions;

    public CustomConversions(@NonNull ConverterConfiguration converterConfiguration) {
        this.converterConfiguration = converterConfiguration;
        List registeredConverters = this.collectPotentialConverterRegistrations(converterConfiguration.getStoreConversions(), converterConfiguration.getUserConverters()).stream().filter(this::isSupportedConverter).filter(this::shouldRegister).map(ConverterRegistrationIntent::getConverterRegistration).map(this::register).distinct().collect(Collectors.toList());
        Collections.reverse(registeredConverters);
        this.converters = Collections.unmodifiableList(registeredConverters);
        this.simpleTypeHolder = new SimpleTypeHolder(this.customSimpleTypes, converterConfiguration.getStoreConversions().getStoreTypeHolder());
        this.propertyValueConversions = converterConfiguration.getPropertyValueConversions();
    }

    public CustomConversions(@NonNull StoreConversions storeConversions, @NonNull Collection<?> converters) {
        this(new ConverterConfiguration(storeConversions, new ArrayList(converters)));
    }

    @NonNull
    public SimpleTypeHolder getSimpleTypeHolder() {
        return this.simpleTypeHolder;
    }

    public boolean hasValueConverter(@NonNull PersistentProperty<?> property) {
        PropertyValueConversions propertyValueConversions = this.getPropertyValueConversions();
        return propertyValueConversions != null && propertyValueConversions.hasValueConverter(property);
    }

    public boolean isSimpleType(@NonNull Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        return this.simpleTypeHolder.isSimpleType(type);
    }

    public void registerConvertersIn(@NonNull ConverterRegistry conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        this.converters.forEach(it -> this.registerConverterIn(it, conversionService));
        CustomCollections.registerConvertersIn(conversionService);
    }

    @Nullable
    public PropertyValueConversions getPropertyValueConversions() {
        return this.propertyValueConversions;
    }

    private List<ConverterRegistrationIntent> collectPotentialConverterRegistrations(@NonNull StoreConversions storeConversions, @NonNull Collection<?> converters) {
        ArrayList<ConverterRegistrationIntent> converterRegistrations = new ArrayList<ConverterRegistrationIntent>();
        converters.stream().map(storeConversions::getRegistrationsFor).flatMap(Streamable::stream).map(ConverterRegistrationIntent::userConverters).forEach(converterRegistrations::add);
        storeConversions.getStoreConverters().stream().map(storeConversions::getRegistrationsFor).flatMap(Streamable::stream).map(ConverterRegistrationIntent::storeConverters).forEach(converterRegistrations::add);
        DEFAULT_CONVERTERS.stream().map(storeConversions::getRegistrationsFor).flatMap(Streamable::stream).map(ConverterRegistrationIntent::defaultConverters).forEach(converterRegistrations::add);
        return converterRegistrations;
    }

    private void registerConverterIn(Object candidate, ConverterRegistry conversionService) {
        if (candidate instanceof Converter) {
            Converter converter = (Converter)candidate;
            conversionService.addConverter(converter);
        } else if (candidate instanceof ConverterFactory) {
            ConverterFactory converterFactory = (ConverterFactory)candidate;
            conversionService.addConverterFactory(converterFactory);
        } else if (candidate instanceof GenericConverter) {
            GenericConverter genericConverter = (GenericConverter)candidate;
            conversionService.addConverter(genericConverter);
        } else if (candidate instanceof ConverterBuilder.ConverterAware) {
            ConverterBuilder.ConverterAware converterAware = (ConverterBuilder.ConverterAware)candidate;
            converterAware.getConverters().forEach(it -> this.registerConverterIn(it, conversionService));
        } else {
            throw new IllegalArgumentException(String.format(NOT_A_CONVERTER, candidate));
        }
    }

    private Object register(@NonNull ConverterRegistration converterRegistration) {
        Assert.notNull((Object)converterRegistration, "Converter registration must not be null");
        GenericConverter.ConvertiblePair pair = converterRegistration.getConvertiblePair();
        if (converterRegistration.isReading()) {
            this.readingPairs.add(pair);
            if (logger.isWarnEnabled() && !converterRegistration.isSimpleSourceType()) {
                logger.warn(String.format(READ_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
        if (converterRegistration.isWriting()) {
            this.writingPairs.add(pair);
            this.customSimpleTypes.add(pair.getSourceType());
            if (logger.isWarnEnabled() && !converterRegistration.isSimpleTargetType()) {
                logger.warn(String.format(WRITE_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
        return converterRegistration.getConverter();
    }

    private boolean isSupportedConverter(@NonNull ConverterRegistrationIntent registrationIntent) {
        boolean register;
        boolean bl = register = registrationIntent.isUserConverter() || registrationIntent.isStoreConverter() || registrationIntent.isReading() && registrationIntent.isSimpleSourceType() || registrationIntent.isWriting() && registrationIntent.isSimpleTargetType();
        if (logger.isDebugEnabled()) {
            if (register) {
                logger.debug(String.format(ADD_CONVERTER, registrationIntent.isUserConverter() ? "user defined " : "", registrationIntent.getSourceType(), registrationIntent.getTargetType(), registrationIntent.isReading() ? "reading" : "writing"));
            } else {
                logger.debug(String.format(SKIP_CONVERTER, registrationIntent.getSourceType(), registrationIntent.getTargetType(), registrationIntent.isReading() ? "reading" : "writing", registrationIntent.isReading() ? registrationIntent.getSourceType() : registrationIntent.getTargetType()));
            }
        }
        return register;
    }

    private boolean shouldRegister(@NonNull ConverterRegistrationIntent intent) {
        return !intent.isDefaultConverter() || this.converterConfiguration.shouldRegister(intent.getConverterRegistration().getConvertiblePair());
    }

    public Optional<Class<?>> getCustomWriteTarget(@NonNull Class<?> sourceType) {
        Assert.notNull(sourceType, "Source type must not be null");
        Class<?> target = this.customWriteTargetTypes.computeIfAbsent(sourceType, this.getRawWriteTarget);
        return Void.class.equals(target) || target == null ? Optional.empty() : Optional.of(target);
    }

    public Optional<Class<?>> getCustomWriteTarget(@NonNull Class<?> sourceType, @NonNull Class<?> requestedTargetType) {
        Assert.notNull(sourceType, "Source type must not be null");
        Assert.notNull(requestedTargetType, "Target type must not be null");
        Class<?> target = this.customWriteTargetTypes.computeIfAbsent(sourceType, requestedTargetType, this.getWriteTarget);
        return Void.class.equals(target) || target == null ? Optional.empty() : Optional.of(target);
    }

    public boolean hasCustomWriteTarget(@NonNull Class<?> sourceType) {
        Assert.notNull(sourceType, "Source type must not be null");
        return this.getCustomWriteTarget(sourceType).isPresent();
    }

    public boolean hasCustomWriteTarget(@NonNull Class<?> sourceType, @NonNull Class<?> targetType) {
        Assert.notNull(sourceType, "Source type must not be null");
        Assert.notNull(targetType, "Target type must not be null");
        return this.getCustomWriteTarget(sourceType, targetType).isPresent();
    }

    public boolean hasCustomReadTarget(@NonNull Class<?> sourceType, @NonNull Class<?> targetType) {
        Assert.notNull(sourceType, "Source type must not be null");
        Assert.notNull(targetType, "Target type must not be null");
        return this.getCustomReadTarget(sourceType, targetType) != null;
    }

    @Nullable
    private Class<?> getCustomReadTarget(@NonNull Class<?> sourceType, @NonNull Class<?> targetType) {
        return this.customReadTargetTypes.computeIfAbsent(sourceType, targetType, this.getReadTarget);
    }

    @Nullable
    private Class<?> getCustomTarget(@NonNull Class<?> sourceType, @Nullable Class<?> targetType, Collection<GenericConverter.ConvertiblePair> pairs) {
        if (targetType != null && pairs.contains(new GenericConverter.ConvertiblePair(sourceType, targetType))) {
            return targetType;
        }
        for (GenericConverter.ConvertiblePair pair : pairs) {
            Class<?> candidate;
            if (!CustomConversions.hasAssignableSourceType(pair, sourceType) || !CustomConversions.requestedTargetTypeIsAssignable(targetType, candidate = pair.getTargetType())) continue;
            return candidate;
        }
        return null;
    }

    private static boolean hasAssignableSourceType(@NonNull GenericConverter.ConvertiblePair pair, @NonNull Class<?> sourceType) {
        return pair.getSourceType().isAssignableFrom(sourceType);
    }

    private static boolean requestedTargetTypeIsAssignable(@Nullable Class<?> requestedTargetType, @NonNull Class<?> targetType) {
        return requestedTargetType == null || targetType.isAssignableFrom(requestedTargetType);
    }

    static {
        ArrayList<Object> defaults = new ArrayList<Object>();
        defaults.addAll(Jsr310Converters.getConvertersToRegister());
        defaults.addAll(JMoleculesConverters.getConvertersToRegister());
        DEFAULT_CONVERTERS = Collections.unmodifiableList(defaults);
    }

    static class ConversionTargetsCache {
        private final Map<Class<?>, TargetTypes> customReadTargetTypes = new ConcurrentHashMap();

        ConversionTargetsCache() {
        }

        @Nullable
        public Class<?> computeIfAbsent(Class<?> sourceType, Function<GenericConverter.ConvertiblePair, Class<?>> mappingFunction) {
            return this.computeIfAbsent(sourceType, AbsentTargetTypeMarker.class, mappingFunction);
        }

        @Nullable
        public Class<?> computeIfAbsent(Class<?> sourceType, Class<?> targetType, Function<GenericConverter.ConvertiblePair, Class<?>> mappingFunction) {
            TargetTypes targetTypes = this.customReadTargetTypes.get(sourceType);
            if (targetTypes == null) {
                targetTypes = this.customReadTargetTypes.computeIfAbsent(sourceType, TargetTypes::new);
            }
            return targetTypes.computeIfAbsent(targetType, mappingFunction);
        }

        static interface AbsentTargetTypeMarker {
        }
    }

    protected static class ConverterConfiguration {
        private final StoreConversions storeConversions;
        private final List<?> userConverters;
        private final Predicate<GenericConverter.ConvertiblePair> converterRegistrationFilter;
        private final PropertyValueConversions propertyValueConversions;

        public ConverterConfiguration(StoreConversions storeConversions, List<?> userConverters) {
            this(storeConversions, userConverters, Predicates.isTrue());
        }

        public ConverterConfiguration(StoreConversions storeConversions, List<?> userConverters, Predicate<GenericConverter.ConvertiblePair> converterRegistrationFilter) {
            this(storeConversions, userConverters, converterRegistrationFilter, PropertyValueConversions.simple(it -> {}));
        }

        public ConverterConfiguration(@NonNull StoreConversions storeConversions, @NonNull List<?> userConverters, @NonNull Predicate<GenericConverter.ConvertiblePair> converterRegistrationFilter, @Nullable PropertyValueConversions propertyValueConversions) {
            this.storeConversions = storeConversions;
            this.userConverters = new ArrayList(userConverters);
            this.converterRegistrationFilter = converterRegistrationFilter;
            this.propertyValueConversions = propertyValueConversions;
        }

        StoreConversions getStoreConversions() {
            return this.storeConversions;
        }

        List<?> getUserConverters() {
            return this.userConverters;
        }

        boolean shouldRegister(GenericConverter.ConvertiblePair candidate) {
            return this.converterRegistrationFilter.test(candidate);
        }

        @Nullable
        public PropertyValueConversions getPropertyValueConversions() {
            return this.propertyValueConversions;
        }
    }

    public static class StoreConversions {
        public static final StoreConversions NONE = StoreConversions.of(SimpleTypeHolder.DEFAULT, Collections.emptyList());
        private final SimpleTypeHolder storeTypeHolder;
        private final Collection<?> storeConverters;

        private StoreConversions(SimpleTypeHolder storeTypeHolder, Collection<?> storeConverters) {
            this.storeTypeHolder = storeTypeHolder;
            this.storeConverters = storeConverters;
        }

        public static StoreConversions of(SimpleTypeHolder storeTypeHolder, Object ... converters) {
            Assert.notNull((Object)storeTypeHolder, "SimpleTypeHolder must not be null");
            Assert.notNull((Object)converters, "Converters must not be null");
            return new StoreConversions(storeTypeHolder, Arrays.asList(converters));
        }

        public static StoreConversions of(SimpleTypeHolder storeTypeHolder, Collection<?> converters) {
            Assert.notNull((Object)storeTypeHolder, "SimpleTypeHolder must not be null");
            Assert.notNull(converters, "Converters must not be null");
            return new StoreConversions(storeTypeHolder, converters);
        }

        public Streamable<ConverterRegistration> getRegistrationsFor(Object converter) {
            Assert.notNull(converter, "Converter must not be null");
            Class<?> type = converter.getClass();
            boolean isWriting = StoreConversions.isAnnotatedWith(type, WritingConverter.class);
            boolean isReading = StoreConversions.isAnnotatedWith(type, ReadingConverter.class);
            if (converter instanceof ConverterBuilder.ConverterAware) {
                ConverterBuilder.ConverterAware converterAware = (ConverterBuilder.ConverterAware)converter;
                return Streamable.of(() -> converterAware.getConverters().stream().flatMap(it -> this.getRegistrationsFor(it).stream()));
            }
            if (converter instanceof GenericConverter) {
                GenericConverter genericConverter = (GenericConverter)converter;
                Set<GenericConverter.ConvertiblePair> convertibleTypes = genericConverter.getConvertibleTypes();
                return convertibleTypes == null ? Streamable.empty() : Streamable.of(convertibleTypes).map(it -> this.register(converter, (GenericConverter.ConvertiblePair)it, isReading, isWriting));
            }
            if (converter instanceof ConverterFactory) {
                return this.getRegistrationFor(converter, ConverterFactory.class, isReading, isWriting);
            }
            if (converter instanceof Converter) {
                return this.getRegistrationFor(converter, Converter.class, isReading, isWriting);
            }
            throw new IllegalArgumentException(String.format("Unsupported converter type %s", converter));
        }

        private static boolean isAnnotatedWith(Class<?> type, Class<? extends Annotation> annotationType) {
            return AnnotationUtils.findAnnotation(type, annotationType) != null;
        }

        private Streamable<ConverterRegistration> getRegistrationFor(Object converter, Class<?> type, boolean isReading, boolean isWriting) {
            Class<?> converterType = converter.getClass();
            Class<?>[] arguments = GenericTypeResolver.resolveTypeArguments(converterType, type);
            if (arguments == null) {
                throw new IllegalStateException(String.format("Couldn't resolve type arguments for %s", converterType));
            }
            return Streamable.of(this.register(converter, arguments[0], arguments[1], isReading, isWriting));
        }

        private ConverterRegistration register(Object converter, Class<?> source, Class<?> target, boolean isReading, boolean isWriting) {
            return this.register(converter, new GenericConverter.ConvertiblePair(source, target), isReading, isWriting);
        }

        private ConverterRegistration register(Object converter, GenericConverter.ConvertiblePair pair, boolean isReading, boolean isWriting) {
            return new ConverterRegistration(converter, pair, this, isReading, isWriting);
        }

        private boolean isStoreSimpleType(Class<?> type) {
            return this.storeTypeHolder.isSimpleType(type);
        }

        SimpleTypeHolder getStoreTypeHolder() {
            return this.storeTypeHolder;
        }

        Collection<?> getStoreConverters() {
            return this.storeConverters;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StoreConversions)) {
                return false;
            }
            StoreConversions that = (StoreConversions)o;
            if (!ObjectUtils.nullSafeEquals(this.storeTypeHolder, that.storeTypeHolder)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.storeConverters, that.storeConverters);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.storeTypeHolder);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.storeConverters);
            return result;
        }

        public String toString() {
            return "StoreConversions{storeTypeHolder=" + this.storeTypeHolder + ", storeConverters=" + this.storeConverters + "}";
        }
    }

    private static class ConverterRegistration {
        private final Object converter;
        private final GenericConverter.ConvertiblePair convertiblePair;
        private final StoreConversions storeConversions;
        private final boolean reading;
        private final boolean writing;

        private ConverterRegistration(Object converter, GenericConverter.ConvertiblePair convertiblePair, StoreConversions storeConversions, boolean reading, boolean writing) {
            this.converter = converter;
            this.convertiblePair = convertiblePair;
            this.storeConversions = storeConversions;
            this.reading = reading;
            this.writing = writing;
        }

        public boolean isWriting() {
            return this.writing || !this.reading && this.isSimpleTargetType();
        }

        public boolean isReading() {
            return this.reading || !this.writing && this.isSimpleSourceType();
        }

        public GenericConverter.ConvertiblePair getConvertiblePair() {
            return this.convertiblePair;
        }

        public boolean isSimpleSourceType() {
            return this.storeConversions.isStoreSimpleType(this.convertiblePair.getSourceType());
        }

        public boolean isSimpleTargetType() {
            return this.storeConversions.isStoreSimpleType(this.convertiblePair.getTargetType());
        }

        Object getConverter() {
            return this.converter;
        }
    }

    protected static class ConverterRegistrationIntent {
        private final ConverterRegistration delegate;
        private final ConverterOrigin origin;

        ConverterRegistrationIntent(ConverterRegistration delegate, ConverterOrigin origin) {
            this.delegate = delegate;
            this.origin = origin;
        }

        static ConverterRegistrationIntent userConverters(ConverterRegistration delegate) {
            return new ConverterRegistrationIntent(delegate, ConverterOrigin.USER_DEFINED);
        }

        static ConverterRegistrationIntent storeConverters(ConverterRegistration delegate) {
            return new ConverterRegistrationIntent(delegate, ConverterOrigin.STORE);
        }

        static ConverterRegistrationIntent defaultConverters(ConverterRegistration delegate) {
            return new ConverterRegistrationIntent(delegate, ConverterOrigin.DEFAULT);
        }

        Class<?> getSourceType() {
            return this.delegate.getConvertiblePair().getSourceType();
        }

        Class<?> getTargetType() {
            return this.delegate.getConvertiblePair().getTargetType();
        }

        public boolean isWriting() {
            return this.delegate.isWriting();
        }

        public boolean isReading() {
            return this.delegate.isReading();
        }

        public boolean isSimpleSourceType() {
            return this.delegate.isSimpleSourceType();
        }

        public boolean isSimpleTargetType() {
            return this.delegate.isSimpleTargetType();
        }

        public boolean isUserConverter() {
            return this.isConverterOfSource(ConverterOrigin.USER_DEFINED);
        }

        public boolean isStoreConverter() {
            return this.isConverterOfSource(ConverterOrigin.STORE);
        }

        public boolean isDefaultConverter() {
            return this.isConverterOfSource(ConverterOrigin.DEFAULT);
        }

        public ConverterRegistration getConverterRegistration() {
            return this.delegate;
        }

        private boolean isConverterOfSource(ConverterOrigin source) {
            return this.origin.equals((Object)source);
        }

        protected static enum ConverterOrigin {
            DEFAULT,
            USER_DEFINED,
            STORE;

        }
    }

    static class TargetTypes {
        private final Class<?> sourceType;
        private final Map<Class<?>, Class<?>> conversionTargets = new ConcurrentHashMap();

        TargetTypes(Class<?> sourceType) {
            this.sourceType = sourceType;
        }

        @Nullable
        public Class<?> computeIfAbsent(Class<?> targetType, Function<GenericConverter.ConvertiblePair, Class<?>> mappingFunction) {
            Class<?> optionalTarget = this.conversionTargets.get(targetType);
            if (optionalTarget == null) {
                optionalTarget = mappingFunction.apply(new GenericConverter.ConvertiblePair(this.sourceType, targetType));
                this.conversionTargets.put(targetType, optionalTarget == null ? Void.class : optionalTarget);
            }
            return Void.class.equals(optionalTarget) ? null : optionalTarget;
        }
    }
}

