/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RedisClusterNode
extends RedisNode {
    private SlotRange slotRange;
    @Nullable
    private LinkState linkState;
    private Set<Flag> flags;

    protected RedisClusterNode() {
        if (this.flags == null) {
            this.flags = Collections.emptySet();
        }
        this.flags = Collections.emptySet();
    }

    public RedisClusterNode(String host, int port) {
        this(host, port, SlotRange.empty());
    }

    public RedisClusterNode(String id) {
        this(SlotRange.empty());
        Assert.notNull((Object)id, "Id must not be null");
        this.id = id;
    }

    public RedisClusterNode(String host, int port, SlotRange slotRange) {
        super(host, port);
        if (this.flags == null) {
            this.flags = Collections.emptySet();
        }
        Assert.notNull((Object)slotRange, "SlotRange must not be null");
        this.slotRange = slotRange;
    }

    public RedisClusterNode(SlotRange slotRange) {
        if (this.flags == null) {
            this.flags = Collections.emptySet();
        }
        Assert.notNull((Object)slotRange, "SlotRange must not be null");
        this.slotRange = slotRange;
    }

    public SlotRange getSlotRange() {
        return this.slotRange;
    }

    public boolean servesSlot(int slot) {
        return this.slotRange.contains(slot);
    }

    @Nullable
    public LinkState getLinkState() {
        return this.linkState;
    }

    public boolean isConnected() {
        return LinkState.CONNECTED.equals((Object)this.linkState);
    }

    public Set<Flag> getFlags() {
        return this.flags == null ? Collections.emptySet() : this.flags;
    }

    public boolean isMarkedAsFail() {
        if (!CollectionUtils.isEmpty(this.flags)) {
            return this.flags.contains((Object)Flag.FAIL) || this.flags.contains((Object)Flag.PFAIL);
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static RedisClusterNodeBuilder newRedisClusterNode() {
        return new RedisClusterNodeBuilder();
    }

    public static class SlotRange {
        private final Set<Integer> range;

        public SlotRange(Integer lowerBound, Integer upperBound) {
            Assert.notNull((Object)lowerBound, "LowerBound must not be null");
            Assert.notNull((Object)upperBound, "UpperBound must not be null");
            this.range = new LinkedHashSet<Integer>();
            for (int i2 = lowerBound.intValue(); i2 <= upperBound; ++i2) {
                this.range.add(i2);
            }
        }

        public SlotRange(Collection<Integer> range) {
            this.range = CollectionUtils.isEmpty(range) ? Collections.emptySet() : new LinkedHashSet<Integer>(range);
        }

        public String toString() {
            return this.range.toString();
        }

        public boolean contains(int slot) {
            return this.range.contains(slot);
        }

        public Set<Integer> getSlots() {
            return Collections.unmodifiableSet(this.range);
        }

        public int[] getSlotsArray() {
            int[] slots = new int[this.range.size()];
            int pos = 0;
            for (Integer value : this.range) {
                slots[pos++] = value;
            }
            return slots;
        }

        public static SlotRange empty() {
            return new SlotRange(Collections.emptySet());
        }
    }

    public static enum LinkState {
        CONNECTED,
        DISCONNECTED;

    }

    public static enum Flag {
        MYSELF("myself"),
        MASTER("master"),
        REPLICA("slave"),
        FAIL("fail"),
        PFAIL("fail?"),
        HANDSHAKE("handshake"),
        NOADDR("noaddr"),
        NOFLAGS("noflags");

        private String raw;

        private Flag(String raw) {
            this.raw = raw;
        }

        public String getRaw() {
            return this.raw;
        }
    }

    public static class RedisClusterNodeBuilder
    extends RedisNode.RedisNodeBuilder {
        @Nullable
        Set<Flag> flags;
        @Nullable
        LinkState linkState;
        SlotRange slotRange = SlotRange.empty();

        @Override
        public RedisClusterNodeBuilder listeningAt(String host, int port) {
            super.listeningAt(host, port);
            return this;
        }

        @Override
        public RedisClusterNodeBuilder withName(String name) {
            super.withName(name);
            return this;
        }

        @Override
        public RedisClusterNodeBuilder withId(String id) {
            super.withId(id);
            return this;
        }

        @Override
        public RedisClusterNodeBuilder promotedAs(RedisNode.NodeType nodeType) {
            super.promotedAs(nodeType);
            return this;
        }

        @Override
        public RedisClusterNodeBuilder replicaOf(String masterId) {
            super.replicaOf(masterId);
            return this;
        }

        public RedisClusterNodeBuilder withFlags(Set<Flag> flags) {
            this.flags = flags;
            return this;
        }

        public RedisClusterNodeBuilder serving(SlotRange range) {
            this.slotRange = range;
            return this;
        }

        public RedisClusterNodeBuilder linkState(LinkState linkState) {
            this.linkState = linkState;
            return this;
        }

        @Override
        public RedisClusterNode build() {
            RedisNode base = super.build();
            RedisClusterNode node = base.host != null ? new RedisClusterNode(base.getHost(), base.getPort(), this.slotRange) : new RedisClusterNode(this.slotRange);
            node.id = base.id;
            node.type = base.type;
            node.masterId = base.masterId;
            node.name = base.name;
            node.flags = this.flags;
            node.linkState = this.linkState;
            return node;
        }
    }
}

