/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.SetPipelineBinaryCommands;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

class JedisSetCommands
implements RedisSetCommands {
    private final JedisConnection connection;

    JedisSetCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)values, "Values must not be null");
        Assert.noNullElements((Object[])values, "Values must not contain null elements");
        return this.connection.invoke().just(Jedis::sadd, SetPipelineBinaryCommands::sadd, key, values);
    }

    @Override
    public Long sCard(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::scard, SetPipelineBinaryCommands::scard, key);
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sdiff, SetPipelineBinaryCommands::sdiff, keys);
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, "Destination key must not be null");
        Assert.notNull((Object)keys, "Source keys must not be null");
        Assert.noNullElements((Object[])keys, "Source keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sdiffstore, SetPipelineBinaryCommands::sdiffstore, destKey, keys);
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sinter, SetPipelineBinaryCommands::sinter, keys);
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, "Destination key must not be null");
        Assert.notNull((Object)keys, "Source keys must not be null");
        Assert.noNullElements((Object[])keys, "Source keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sinterstore, SetPipelineBinaryCommands::sinterstore, destKey, keys);
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().just(Jedis::sismember, SetPipelineBinaryCommands::sismember, key, value);
    }

    @Override
    public List<Boolean> sMIsMember(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)values, "Values must not be null");
        Assert.noNullElements((Object[])values, "Values must not contain null elements");
        return this.connection.invoke().just(Jedis::smismember, SetPipelineBinaryCommands::smismember, key, values);
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::smembers, SetPipelineBinaryCommands::smembers, key);
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        Assert.notNull((Object)srcKey, "Source key must not be null");
        Assert.notNull((Object)destKey, "Destination key must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return this.connection.invoke().from(Jedis::smove, SetPipelineBinaryCommands::smove, srcKey, destKey, value).get(Converters::toBoolean);
    }

    @Override
    public byte[] sPop(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::spop, SetPipelineBinaryCommands::spop, key);
    }

    @Override
    public List<byte[]> sPop(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().from(Jedis::spop, SetPipelineBinaryCommands::spop, key, count).get(ArrayList::new);
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null");
        return this.connection.invoke().just(Jedis::srandmember, SetPipelineBinaryCommands::srandmember, key);
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null");
        if (count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count must be less than Integer.MAX_VALUE for sRandMember in Jedis");
        }
        return this.connection.invoke().just(Jedis::srandmember, SetPipelineBinaryCommands::srandmember, key, (int)count);
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)values, "Values must not be null");
        Assert.noNullElements((Object[])values, "Values must not contain null elements");
        return this.connection.invoke().just(Jedis::srem, SetPipelineBinaryCommands::srem, key, values);
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sunion, SetPipelineBinaryCommands::sunion, keys);
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, "Destination key must not be null");
        Assert.notNull((Object)keys, "Source keys must not be null");
        Assert.noNullElements((Object[])keys, "Source keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sunionstore, SetPipelineBinaryCommands::sunionstore, destKey, keys);
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options2) {
        return this.sScan(key, 0L, options2);
    }

    public Cursor<byte[]> sScan(byte[] key, long cursorId, ScanOptions options2) {
        Assert.notNull((Object)key, "Key must not be null");
        return new KeyBoundCursor<byte[]>(key, cursorId, options2){

            @Override
            protected ScanIteration<byte[]> doScan(byte[] key, long cursorId, ScanOptions options2) {
                if (JedisSetCommands.this.isQueueing() || JedisSetCommands.this.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'SSCAN' cannot be called in pipeline / transaction mode");
                }
                ScanParams params = JedisConverters.toScanParams(options2);
                ScanResult result = JedisSetCommands.this.connection.getJedis().sscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getCursor()), result.getResult());
            }

            @Override
            protected void doClose() {
                JedisSetCommands.this.connection.close();
            }
        }.open();
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

