/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceFutureUtils;
import org.springframework.data.redis.connection.lettuce.RedisClientProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ClusterConnectionProvider
implements LettuceConnectionProvider,
RedisClientProvider {
    private final RedisClusterClient client;
    private final RedisCodec<?, ?> codec;
    private final Optional<ReadFrom> readFrom;
    private final Object monitor = new Object();
    private volatile boolean initialized;

    ClusterConnectionProvider(RedisClusterClient client, RedisCodec<?, ?> codec) {
        this(client, codec, null);
    }

    ClusterConnectionProvider(RedisClusterClient client, RedisCodec<?, ?> codec, @Nullable ReadFrom readFrom) {
        Assert.notNull((Object)client, "Client must not be null");
        Assert.notNull(codec, "Codec must not be null");
        this.client = client;
        this.codec = codec;
        this.readFrom = Optional.ofNullable(readFrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends StatefulConnection<?, ?>> CompletableFuture<T> getConnectionAsync(Class<T> connectionType) {
        block10: {
            block9: {
                if (!this.initialized) {
                    Object object = this.monitor;
                    synchronized (object) {
                        if (!this.initialized) {
                            this.client.getPartitions();
                            this.initialized = true;
                        }
                    }
                }
                if (connectionType.equals(StatefulRedisPubSubConnection.class)) break block9;
                if (!connectionType.equals(StatefulRedisClusterPubSubConnection.class)) break block10;
            }
            return this.client.connectPubSubAsync(this.codec).thenApply(connectionType::cast);
        }
        if (StatefulRedisClusterConnection.class.isAssignableFrom(connectionType) || connectionType.equals(StatefulConnection.class)) {
            return this.client.connectAsync(this.codec).thenApply(connection -> {
                this.readFrom.ifPresent(connection::setReadFrom);
                return (StatefulConnection)connectionType.cast(connection);
            });
        }
        return LettuceFutureUtils.failed(new InvalidDataAccessApiUsageException("Connection type " + connectionType + " not supported"));
    }

    @Override
    public RedisClusterClient getRedisClient() {
        return this.client;
    }
}

