/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceListCommands;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class LettuceClusterListCommands
extends LettuceListCommands {
    private final LettuceClusterConnection connection;

    LettuceClusterListCommands(LettuceClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.bLPop(timeout, keys);
        }
        List resultList = this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.blpop(timeout, (K[])new byte[][]{key}), Arrays.asList(keys)).resultsAsList();
        for (KeyValue kv : resultList) {
            if (kv == null) continue;
            return LettuceConverters.toBytesList(kv);
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.bRPop(timeout, keys);
        }
        List resultList = this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.brpop(timeout, (K[])new byte[][]{key}), Arrays.asList(keys)).resultsAsList();
        for (KeyValue kv : resultList) {
            if (kv == null) continue;
            return LettuceConverters.toBytesList(kv);
        }
        return Collections.emptyList();
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, "Source key must not be null");
        Assert.notNull((Object)dstKey, "Destination key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            return super.rPopLPush(srcKey, dstKey);
        }
        byte[] val2 = this.rPop(srcKey);
        this.lPush(dstKey, new byte[][]{val2});
        return val2;
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, "Source key must not be null");
        Assert.notNull((Object)dstKey, "Destination key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            return super.bRPopLPush(timeout, srcKey, dstKey);
        }
        List<byte[]> val2 = this.bRPop(timeout, new byte[][]{srcKey});
        if (!CollectionUtils.isEmpty(val2)) {
            this.lPush(dstKey, new byte[][]{val2.get(1)});
            return val2.get(1);
        }
        return null;
    }
}

