/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.async.RedisHLLAsyncCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.util.Assert;

class LettuceHyperLogLogCommands
implements RedisHyperLogLogCommands {
    private final LettuceConnection connection;

    LettuceHyperLogLogCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        Assert.notEmpty((Object[])values, "PFADD requires at least one non 'null' value.");
        Assert.noNullElements((Object[])values, "Values for PFADD must not contain 'null'");
        return (Long)this.connection.invoke().just(RedisHLLAsyncCommands::pfadd, key, values);
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        Assert.notEmpty((Object[])keys, "PFCOUNT requires at least one non 'null' key.");
        Assert.noNullElements((Object[])keys, "Keys for PFCOUNT must not contain 'null'");
        return (Long)this.connection.invoke().just(RedisHLLAsyncCommands::pfcount, keys);
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        Assert.notNull((Object)destinationKey, "Destination key must not be null");
        Assert.notNull((Object)sourceKeys, "Source keys must not be null");
        Assert.noNullElements((Object[])sourceKeys, "Keys for PFMERGE must not contain 'null'");
        this.connection.invoke().just(RedisHLLAsyncCommands::pfmerge, destinationKey, sourceKeys);
    }
}

