/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisException;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ReactiveClusterKeyCommands;
import org.springframework.data.redis.connection.ReactiveKeyCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisClusterConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveClusterKeyCommands
extends LettuceReactiveKeyCommands
implements ReactiveClusterKeyCommands {
    private LettuceReactiveRedisClusterConnection connection;

    LettuceReactiveClusterKeyCommands(LettuceReactiveRedisClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public Mono<List<ByteBuffer>> keys(RedisClusterNode node, ByteBuffer pattern) {
        return this.connection.execute(node, cmd -> {
            Assert.notNull((Object)pattern, "Pattern must not be null");
            return cmd.keys(pattern).collectList();
        }).next();
    }

    @Override
    public Mono<ByteBuffer> randomKey(RedisClusterNode node) {
        return this.connection.execute(node, RedisKeyReactiveCommands::randomkey).next();
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> rename(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Old key must not be null");
            Assert.notNull((Object)command.getNewKey(), "New key must not be null");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKey(), command.getNewKey())) {
                return super.rename(Mono.just(command));
            }
            Mono<Boolean> result = cmd.dump(command.getKey()).switchIfEmpty(Mono.error(new RedisSystemException("Cannot rename key that does not exist", new RedisException("ERR no such key.")))).flatMap(value -> cmd.restore(command.getNewKey(), 0L, (byte[])value).flatMap(res -> cmd.del(command.getKey()))).map(LettuceConverters.longToBooleanConverter()::convert);
            return result.map(val2 -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)val2));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>> renameNX(Publisher<ReactiveKeyCommands.RenameCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getNewKey(), "NewName must not be null");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKey(), command.getNewKey())) {
                return super.renameNX(Mono.just(command));
            }
            Mono<ReactiveRedisConnection.BooleanResponse> result = cmd.exists(command.getNewKey()).flatMap(exists -> {
                if (exists == 1L) {
                    return Mono.just(Boolean.FALSE);
                }
                return cmd.dump(command.getKey()).switchIfEmpty(Mono.error(new RedisSystemException("Cannot rename key that does not exist", new RedisException("ERR no such key.")))).flatMap(value -> cmd.restore(command.getNewKey(), 0L, (byte[])value).flatMap(res -> cmd.del(command.getKey()))).map(Converters::toBoolean);
            });
            return result.map(val2 -> new ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.RenameCommand>((ReactiveKeyCommands.RenameCommand)command, (Boolean)val2));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveKeyCommands.MoveCommand>> move(Publisher<ReactiveKeyCommands.MoveCommand> commands) {
        throw new InvalidDataAccessApiUsageException("MOVE not supported in CLUSTER mode");
    }
}

