/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisCredentialsProvider;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public interface RedisCredentialsProviderFactory {
    @Nullable
    default public RedisCredentialsProvider createCredentialsProvider(RedisConfiguration redisConfiguration) {
        if (redisConfiguration instanceof RedisConfiguration.WithAuthentication && ((RedisConfiguration.WithAuthentication)((Object)redisConfiguration)).getPassword().isPresent()) {
            return RedisCredentialsProvider.from(() -> {
                RedisConfiguration.WithAuthentication withAuthentication = (RedisConfiguration.WithAuthentication)((Object)redisConfiguration);
                return RedisCredentials.just(withAuthentication.getUsername(), withAuthentication.getPassword().get());
            });
        }
        return () -> Mono.just(AbsentRedisCredentials.ANONYMOUS);
    }

    default public RedisCredentialsProvider createSentinelCredentialsProvider(RedisSentinelConfiguration redisConfiguration) {
        if (redisConfiguration.getSentinelPassword().isPresent()) {
            return RedisCredentialsProvider.from(() -> RedisCredentials.just(redisConfiguration.getSentinelUsername(), redisConfiguration.getSentinelPassword().get()));
        }
        return () -> Mono.just(AbsentRedisCredentials.ANONYMOUS);
    }

    public static enum AbsentRedisCredentials implements RedisCredentials
    {
        ANONYMOUS;


        @Override
        @Nullable
        public String getUsername() {
            return null;
        }

        @Override
        public boolean hasUsername() {
            return false;
        }

        @Override
        @Nullable
        public char[] getPassword() {
            return null;
        }

        @Override
        public boolean hasPassword() {
            return false;
        }
    }
}

