/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce.observability;

import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.TraceContext;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.Tracer;
import io.lettuce.core.tracing.TracerProvider;
import io.lettuce.core.tracing.Tracing;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.redis.connection.lettuce.observability.DefaultLettuceObservationConvention;
import org.springframework.data.redis.connection.lettuce.observability.LettuceObservationContext;
import org.springframework.data.redis.connection.lettuce.observability.LettuceObservationConvention;
import org.springframework.data.redis.connection.lettuce.observability.RedisObservation;
import org.springframework.data.redis.connection.lettuce.observability.SocketAddressEndpoint;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public class MicrometerTracingAdapter
implements Tracing {
    private static final Log log = LogFactory.getLog(MicrometerTracingAdapter.class);
    private final ObservationRegistry observationRegistry;
    private final String serviceName;
    private final boolean includeCommandArgsInSpanTags;
    private final LettuceObservationConvention observationConvention;

    public MicrometerTracingAdapter(ObservationRegistry observationRegistry, String serviceName) {
        this(observationRegistry, serviceName, false);
    }

    public MicrometerTracingAdapter(ObservationRegistry observationRegistry, String serviceName, boolean includeCommandArgsInSpanTags) {
        this.observationRegistry = observationRegistry;
        this.serviceName = serviceName;
        this.observationConvention = new DefaultLettuceObservationConvention(includeCommandArgsInSpanTags);
        this.includeCommandArgsInSpanTags = includeCommandArgsInSpanTags;
    }

    @Override
    public TracerProvider getTracerProvider() {
        return () -> new MicrometerTracer(this.observationRegistry);
    }

    @Override
    public TraceContextProvider initialTraceContextProvider() {
        return new MicrometerTraceContextProvider(this.observationRegistry);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean includeCommandArgsInSpanTags() {
        return this.includeCommandArgsInSpanTags;
    }

    @Override
    public Tracing.Endpoint createEndpoint(SocketAddress socketAddress) {
        return new SocketAddressEndpoint(socketAddress);
    }

    record MicrometerTraceContextProvider(ObservationRegistry registry) implements TraceContextProvider
    {
        @Override
        public TraceContext getTraceContext() {
            Observation observation = this.registry.getCurrentObservation();
            if (observation == null) {
                return null;
            }
            return new MicrometerTraceContext(observation);
        }

        @Override
        public Mono<TraceContext> getTraceContextLater() {
            return Mono.deferContextual(Mono::justOrEmpty).filter(it -> it.hasKey(TraceContext.class) || it.hasKey(Observation.class) || it.hasKey("micrometer.observation")).map(it -> {
                if (it.hasKey(Observation.class)) {
                    return new MicrometerTraceContext(it.get(Observation.class));
                }
                if (it.hasKey(TraceContext.class)) {
                    return it.get(TraceContext.class);
                }
                return new MicrometerTraceContext((Observation)it.get("micrometer.observation"));
            });
        }
    }

    class MicrometerTracer
    extends Tracer {
        private final ObservationRegistry observationRegistry;

        public MicrometerTracer(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
        }

        @Override
        public Tracer.Span nextSpan() {
            return this.postProcessSpan(this.createObservation());
        }

        @Override
        public Tracer.Span nextSpan(TraceContext traceContext) {
            if (traceContext instanceof MicrometerTraceContext) {
                MicrometerTraceContext micrometerTraceContext = (MicrometerTraceContext)traceContext;
                return micrometerTraceContext.observation == null ? this.nextSpan() : this.postProcessSpan(this.createObservation().parentObservation(micrometerTraceContext.observation()));
            }
            return this.nextSpan();
        }

        private Observation createObservation() {
            return RedisObservation.REDIS_COMMAND_OBSERVATION.observation(this.observationRegistry, () -> new LettuceObservationContext(MicrometerTracingAdapter.this.serviceName));
        }

        private Tracer.Span postProcessSpan(Observation observation) {
            return observation != null && !observation.isNoop() ? new MicrometerSpan(observation.observationConvention(MicrometerTracingAdapter.this.observationConvention)) : NoOpSpan.INSTANCE;
        }
    }

    record MicrometerTraceContext(Observation observation) implements TraceContext
    {
    }

    static class MicrometerSpan
    extends Tracer.Span {
        private final Observation observation;
        @Nullable
        private RedisCommand<?, ?, ?> command;

        public MicrometerSpan(Observation observation) {
            this.observation = observation;
        }

        @Override
        public Tracer.Span start(RedisCommand<?, ?, ?> command) {
            ((LettuceObservationContext)this.observation.getContext()).setCommand(command);
            this.command = command;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Starting Observation for Command %s", command));
            }
            if (!(command instanceof CompleteableCommand)) {
                throw new IllegalArgumentException("Command " + command + " must implement CompleteableCommand to attach Span completion to command completion");
            }
            CompleteableCommand completeableCommand = (CompleteableCommand)((Object)command);
            completeableCommand.onComplete((o, throwable) -> {
                if (command.getOutput() != null) {
                    String error = command.getOutput().getError();
                    if (error != null) {
                        this.observation.highCardinalityKeyValue(RedisObservation.HighCardinalityCommandKeyNames.ERROR.withValue(error));
                    } else if (throwable != null) {
                        this.error((Throwable)throwable);
                    }
                }
                this.finish();
            });
            this.observation.start();
            return this;
        }

        @Override
        public Tracer.Span name(String name) {
            return this;
        }

        @Override
        public Tracer.Span annotate(String annotation) {
            return this;
        }

        @Override
        public Tracer.Span tag(String key, String value) {
            this.observation.highCardinalityKeyValue(key, value);
            return this;
        }

        @Override
        public Tracer.Span error(Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Attaching error to Observation for Command %s", this.command));
            }
            this.observation.error(throwable);
            return this;
        }

        @Override
        public Tracer.Span remoteEndpoint(Tracing.Endpoint endpoint) {
            ((LettuceObservationContext)this.observation.getContext()).setEndpoint(endpoint);
            return this;
        }

        @Override
        public void finish() {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Stopping Observation for Command %s", this.command));
            }
            this.observation.stop();
        }
    }

    static class NoOpSpan
    extends Tracer.Span {
        static final NoOpSpan INSTANCE = new NoOpSpan();

        @Override
        public Tracer.Span start(RedisCommand<?, ?, ?> command) {
            return this;
        }

        @Override
        public Tracer.Span name(String name) {
            return this;
        }

        @Override
        public Tracer.Span annotate(String value) {
            return this;
        }

        @Override
        public Tracer.Span tag(String key, String value) {
            return this;
        }

        @Override
        public Tracer.Span error(Throwable throwable) {
            return this;
        }

        @Override
        public Tracer.Span remoteEndpoint(Tracing.Endpoint endpoint) {
            return this;
        }

        @Override
        public void finish() {
        }
    }
}

