/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce.observability;

import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.docs.ObservationDocumentation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum RedisObservation implements ObservationDocumentation
{
    REDIS_COMMAND_OBSERVATION{

        @Override
        public String getName() {
            return "spring.data.redis";
        }

        @Override
        public KeyName[] getLowCardinalityKeyNames() {
            return LowCardinalityCommandKeyNames.values();
        }

        @Override
        public KeyName[] getHighCardinalityKeyNames() {
            return HighCardinalityCommandKeyNames.values();
        }
    };


    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum HighCardinalityCommandKeyNames implements KeyName
    {
        STATEMENT{

            @Override
            public String asString() {
                return "db.statement";
            }
        }
        ,
        ERROR{

            @Override
            public String asString() {
                return "spring.data.redis.command.error";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum LowCardinalityCommandKeyNames implements KeyName
    {
        DATABASE_SYSTEM{

            @Override
            public String asString() {
                return "db.system";
            }
        }
        ,
        NET_TRANSPORT{

            @Override
            public String asString() {
                return "net.transport";
            }
        }
        ,
        NET_PEER_NAME{

            @Override
            public String asString() {
                return "net.peer.name";
            }
        }
        ,
        NET_PEER_PORT{

            @Override
            public String asString() {
                return "net.peer.port";
            }
        }
        ,
        NET_SOCK_PEER_ADDR{

            @Override
            public String asString() {
                return "net.sock.peer.addr";
            }
        }
        ,
        NET_SOCK_PEER_PORT{

            @Override
            public String asString() {
                return "net.sock.peer.port";
            }
        }
        ,
        DB_USER{

            @Override
            public String asString() {
                return "db.user";
            }
        }
        ,
        DB_INDEX{

            @Override
            public String asString() {
                return "db.redis.database_index";
            }
        }
        ,
        REDIS_COMMAND{

            @Override
            public String asString() {
                return "db.operation";
            }
        };

    }
}

