/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;

final class BinaryConverters {
    public static final Charset CHARSET = StandardCharsets.UTF_8;

    private BinaryConverters() {
    }

    @ReadingConverter
    static class BytesToUuidConverter
    extends StringBasedConverter
    implements Converter<byte[], UUID> {
        BytesToUuidConverter() {
        }

        @Override
        public UUID convert(byte[] source) {
            if (ObjectUtils.isEmpty((Object)source)) {
                return null;
            }
            return UUID.fromString(this.toString(source));
        }
    }

    @WritingConverter
    static class UuidToBytesConverter
    extends StringBasedConverter
    implements Converter<UUID, byte[]> {
        UuidToBytesConverter() {
        }

        @Override
        public byte[] convert(UUID source) {
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToDateConverter
    extends StringBasedConverter
    implements Converter<byte[], Date> {
        BytesToDateConverter() {
        }

        @Override
        public Date convert(byte[] source) {
            if (ObjectUtils.isEmpty((Object)source)) {
                return null;
            }
            String value = this.toString(source);
            try {
                return new Date(NumberUtils.parseNumber(value, Long.class));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return DateFormat.getInstance().parse(value);
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException(String.format("Cannot parse date out of %s", Arrays.toString(source)));
                }
            }
        }
    }

    @WritingConverter
    static class DateToBytesConverter
    extends StringBasedConverter
    implements Converter<Date, byte[]> {
        DateToBytesConverter() {
        }

        @Override
        public byte[] convert(Date source) {
            return this.fromString(Long.toString(source.getTime()));
        }
    }

    @ReadingConverter
    static class BytesToBooleanConverter
    extends StringBasedConverter
    implements Converter<byte[], Boolean> {
        BytesToBooleanConverter() {
        }

        @Override
        public Boolean convert(byte[] source) {
            if (ObjectUtils.isEmpty((Object)source)) {
                return null;
            }
            String value = this.toString(source);
            return "1".equals(value) || "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    @WritingConverter
    static class BooleanToBytesConverter
    extends StringBasedConverter
    implements Converter<Boolean, byte[]> {
        byte[] _true = this.fromString("1");
        byte[] _false = this.fromString("0");

        BooleanToBytesConverter() {
        }

        @Override
        public byte[] convert(Boolean source) {
            return source != false ? this._true : this._false;
        }
    }

    @ReadingConverter
    static class BytesToNumberConverterFactory
    implements ConverterFactory<byte[], Number> {
        BytesToNumberConverterFactory() {
        }

        @Override
        public <T extends Number> Converter<byte[], T> getConverter(Class<T> targetType) {
            return new BytesToNumberConverter<T>(targetType);
        }

        private static final class BytesToNumberConverter<T extends Number>
        extends StringBasedConverter
        implements Converter<byte[], T> {
            private final Class<T> targetType;

            public BytesToNumberConverter(Class<T> targetType) {
                this.targetType = targetType;
            }

            @Override
            public T convert(byte[] source) {
                if (ObjectUtils.isEmpty((Object)source)) {
                    return null;
                }
                return NumberUtils.parseNumber(this.toString(source), this.targetType);
            }
        }
    }

    @ReadingConverter
    static final class BytesToEnumConverterFactory
    implements ConverterFactory<byte[], Enum<?>> {
        BytesToEnumConverterFactory() {
        }

        @Override
        public <T extends Enum<?>> Converter<byte[], T> getConverter(Class<T> targetType) {
            Class<T> enumType;
            for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
            }
            if (enumType == null) {
                throw new IllegalArgumentException("The target type " + targetType.getName() + " does not refer to an enum");
            }
            return new BytesToEnum<T>(enumType);
        }

        private class BytesToEnum<T extends Enum<T>>
        extends StringBasedConverter
        implements Converter<byte[], T> {
            private final Class<T> enumType;

            public BytesToEnum(Class<T> enumType) {
                this.enumType = enumType;
            }

            @Override
            public T convert(byte[] source) {
                if (ObjectUtils.isEmpty((Object)source)) {
                    return null;
                }
                return Enum.valueOf(this.enumType, this.toString(source).trim());
            }
        }
    }

    @WritingConverter
    static class EnumToBytesConverter
    extends StringBasedConverter
    implements Converter<Enum<?>, byte[]> {
        EnumToBytesConverter() {
        }

        @Override
        public byte[] convert(Enum<?> source) {
            return this.fromString(source.name());
        }
    }

    @WritingConverter
    static class NumberToBytesConverter
    extends StringBasedConverter
    implements Converter<Number, byte[]> {
        NumberToBytesConverter() {
        }

        @Override
        public byte[] convert(Number source) {
            return this.fromString(source.toString());
        }
    }

    @ReadingConverter
    static class BytesToStringConverter
    extends StringBasedConverter
    implements Converter<byte[], String> {
        BytesToStringConverter() {
        }

        @Override
        public String convert(byte[] source) {
            return this.toString(source);
        }
    }

    @WritingConverter
    static class StringToBytesConverter
    extends StringBasedConverter
    implements Converter<String, byte[]> {
        StringToBytesConverter() {
        }

        @Override
        public byte[] convert(String source) {
            return this.fromString(source);
        }
    }

    static class StringBasedConverter {
        StringBasedConverter() {
        }

        byte[] fromString(String source) {
            return source.getBytes(CHARSET);
        }

        String toString(byte[] source) {
            return new String(source, CHARSET);
        }
    }
}

