/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.index;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.data.redis.core.index.ConfigurableIndexDefinitionProvider;
import org.springframework.data.redis.core.index.IndexDefinition;
import org.springframework.data.redis.core.index.PathBasedRedisIndexDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class IndexConfiguration
implements ConfigurableIndexDefinitionProvider {
    private final Set<IndexDefinition> definitions = new CopyOnWriteArraySet<IndexDefinition>();

    public IndexConfiguration() {
        for (IndexDefinition indexDefinition : this.initialConfiguration()) {
            this.addIndexDefinition(indexDefinition);
        }
    }

    @Override
    public boolean hasIndexFor(Serializable keyspace) {
        return !this.getIndexDefinitionsFor(keyspace).isEmpty();
    }

    @Override
    public boolean hasIndexFor(Serializable keyspace, String path) {
        return !this.getIndexDefinitionsFor(keyspace, path).isEmpty();
    }

    @Override
    public Set<IndexDefinition> getIndexDefinitionsFor(Serializable keyspace, String path) {
        return this.getIndexDefinitions(keyspace, path, Object.class);
    }

    @Override
    public Set<IndexDefinition> getIndexDefinitionsFor(Serializable keyspace) {
        LinkedHashSet<IndexDefinition> indexDefinitions = new LinkedHashSet<IndexDefinition>();
        for (IndexDefinition indexDef : this.definitions) {
            if (!indexDef.getKeyspace().equals(keyspace)) continue;
            indexDefinitions.add(indexDef);
        }
        return indexDefinitions;
    }

    @Override
    public void addIndexDefinition(IndexDefinition indexDefinition) {
        Assert.notNull((Object)indexDefinition, "RedisIndexDefinition must not be null in order to be added");
        this.definitions.add(indexDefinition);
    }

    private Set<IndexDefinition> getIndexDefinitions(Serializable keyspace, String path, Class<?> type) {
        LinkedHashSet<IndexDefinition> def = new LinkedHashSet<IndexDefinition>();
        for (IndexDefinition indexDef : this.definitions) {
            if (!ClassUtils.isAssignable(type, indexDef.getClass()) || !indexDef.getKeyspace().equals(keyspace)) continue;
            if (indexDef instanceof PathBasedRedisIndexDefinition) {
                if (!ObjectUtils.nullSafeEquals(((PathBasedRedisIndexDefinition)indexDef).getPath(), path)) continue;
                def.add(indexDef);
                continue;
            }
            def.add(indexDef);
        }
        return def;
    }

    protected Iterable<? extends IndexDefinition> initialConfiguration() {
        return Collections.emptySet();
    }
}

