/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class QTypeContributor {
    private static final Log logger = LogFactory.getLog(QTypeContributor.class);

    public static void contributeEntityPath(Class<?> type, GenerationContext context, @Nullable ClassLoader classLoader) {
        try {
            Class<?> entityPathType = QTypeContributor.getEntityPathType(classLoader);
            if (entityPathType == null) {
                return;
            }
            String queryClassName = QTypeContributor.getQueryClassName(type);
            if (ClassUtils.isPresent(queryClassName, classLoader)) {
                if (ClassUtils.isAssignable(entityPathType, ClassUtils.forName(queryClassName, classLoader))) {
                    logger.debug("Registering Q type %s for %s.");
                    context.getRuntimeHints().reflection().registerType(TypeReference.of(queryClassName), MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS);
                } else {
                    logger.debug("Skipping Q type %s. Not an EntityPath.");
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot contribute Q class for domain type %s".formatted(type.getName()), e);
        }
    }

    @Nullable
    private static Class<?> getEntityPathType(@Nullable ClassLoader classLoader) throws ClassNotFoundException {
        String entityPathClassName = "com.querydsl.core.types.EntityPath";
        if (!ClassUtils.isPresent(entityPathClassName, classLoader)) {
            return null;
        }
        return ClassUtils.forName(entityPathClassName, classLoader);
    }

    private static String getQueryClassName(Class<?> domainClass) {
        String simpleClassName = ClassUtils.getShortName(domainClass);
        String pkgName = domainClass.getPackage().getName();
        return String.format("%s.Q%s%s", pkgName, QTypeContributor.getClassBase(simpleClassName), domainClass.getSimpleName());
    }

    private static String getClassBase(String shortName) {
        String[] parts = shortName.split("\\.");
        return parts.length < 2 ? "" : parts[0] + "_";
    }
}

