/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configuration;

import java.util.Set;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.util.ClassUtils;

class AuthenticationManagerBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    AuthenticationManagerBeanRegistrationAotProcessor() {
    }

    @Override
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        Set<Class<?>> allInterfacesForClass = ClassUtils.getAllInterfacesForClassAsSet(beanClass);
        if (allInterfacesForClass.contains(AuthenticationManager.class)) {
            return new AuthenticationManagerBeanRegistrationAotContribution();
        }
        return null;
    }

    private static class AuthenticationManagerBeanRegistrationAotContribution
    implements BeanRegistrationAotContribution {
        private AuthenticationManagerBeanRegistrationAotContribution() {
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ProxyHints proxyHints = generationContext.getRuntimeHints().proxies();
            proxyHints.registerJdkProxy(AopProxyUtils.completeJdkProxyInterfaces(AuthenticationManager.class));
        }
    }
}

