/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.LinkedHashSet;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

final class OAuth2ImportSelector
implements ImportSelector {
    OAuth2ImportSelector() {
    }

    @Override
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        boolean oauth2ClientPresent = ClassUtils.isPresent("org.springframework.security.oauth2.client.registration.ClientRegistration", classLoader);
        boolean webfluxPresent = ClassUtils.isPresent("org.springframework.web.reactive.function.client.ExchangeFilterFunction", classLoader);
        boolean oauth2ResourceServerPresent = ClassUtils.isPresent("org.springframework.security.oauth2.server.resource.BearerTokenError", classLoader);
        if (oauth2ClientPresent) {
            imports.add("org.springframework.security.config.annotation.web.configuration.OAuth2ClientConfiguration");
        }
        if (webfluxPresent && oauth2ClientPresent) {
            imports.add("org.springframework.security.config.annotation.web.configuration.SecurityReactorContextConfiguration");
        }
        if (webfluxPresent && oauth2ResourceServerPresent) {
            imports.add("org.springframework.security.config.annotation.web.configuration.SecurityReactorContextConfiguration");
        }
        return StringUtils.toStringArray(imports);
    }
}

