/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.bind.support.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.web.method.annotation.CsrfTokenArgumentResolver;
import org.springframework.security.web.method.annotation.CurrentSecurityContextArgumentResolver;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

class WebMvcSecurityConfiguration
implements WebMvcConfigurer,
ApplicationContextAware {
    private BeanResolver beanResolver;
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    WebMvcSecurityConfiguration() {
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        org.springframework.security.web.method.annotation.AuthenticationPrincipalArgumentResolver authenticationPrincipalResolver = new org.springframework.security.web.method.annotation.AuthenticationPrincipalArgumentResolver();
        authenticationPrincipalResolver.setBeanResolver(this.beanResolver);
        authenticationPrincipalResolver.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
        argumentResolvers.add(authenticationPrincipalResolver);
        argumentResolvers.add(new AuthenticationPrincipalArgumentResolver());
        CurrentSecurityContextArgumentResolver currentSecurityContextArgumentResolver = new CurrentSecurityContextArgumentResolver();
        currentSecurityContextArgumentResolver.setBeanResolver(this.beanResolver);
        currentSecurityContextArgumentResolver.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
        argumentResolvers.add(currentSecurityContextArgumentResolver);
        argumentResolvers.add(new CsrfTokenArgumentResolver());
    }

    @Bean
    RequestDataValueProcessor requestDataValueProcessor() {
        return new CsrfRequestDataValueProcessor();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanResolver = new BeanFactoryResolver(applicationContext.getAutowireCapableBeanFactory());
        if (applicationContext.getBeanNamesForType(SecurityContextHolderStrategy.class).length == 1) {
            this.securityContextHolderStrategy = applicationContext.getBean(SecurityContextHolderStrategy.class);
        }
    }
}

