/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class UnmodifiableMapDeserializer
extends JsonDeserializer<Map<?, ?>> {
    UnmodifiableMapDeserializer() {
    }

    @Override
    public Map<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (node != null && node.isObject()) {
            Iterable fields = node::fields;
            for (Map.Entry field : fields) {
                result.put((String)field.getKey(), mapper.readValue(((JsonNode)field.getValue()).traverse(mapper), Object.class));
            }
        }
        return Collections.unmodifiableMap(result);
    }
}

