/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public final class RequestMatcherRedirectFilter
extends OncePerRequestFilter {
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private final RequestMatcher requestMatcher;
    private final String redirectUrl;

    public RequestMatcherRedirectFilter(RequestMatcher requestMatcher, String redirectUrl) {
        Assert.notNull((Object)requestMatcher, "requestMatcher cannot be null");
        Assert.hasText(redirectUrl, "redirectUrl cannot be empty");
        this.requestMatcher = requestMatcher;
        this.redirectUrl = redirectUrl;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request2, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.requestMatcher.matches(request2)) {
            this.redirectStrategy.sendRedirect(request2, response, this.redirectUrl);
        } else {
            filterChain.doFilter(request2, response);
        }
    }
}

