/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.Assert;

public class DelegatingAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private final LinkedHashMap<Class<? extends AuthenticationException>, AuthenticationFailureHandler> handlers;
    private final AuthenticationFailureHandler defaultHandler;

    public DelegatingAuthenticationFailureHandler(LinkedHashMap<Class<? extends AuthenticationException>, AuthenticationFailureHandler> handlers, AuthenticationFailureHandler defaultHandler) {
        Assert.notEmpty(handlers, "handlers cannot be null or empty");
        Assert.notNull((Object)defaultHandler, "defaultHandler cannot be null");
        this.handlers = handlers;
        this.defaultHandler = defaultHandler;
    }

    @Override
    public void onAuthenticationFailure(HttpServletRequest request2, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        for (Map.Entry<Class<? extends AuthenticationException>, AuthenticationFailureHandler> entry : this.handlers.entrySet()) {
            Class<? extends AuthenticationException> handlerMappedExceptionClass = entry.getKey();
            if (!handlerMappedExceptionClass.isAssignableFrom(exception.getClass())) continue;
            AuthenticationFailureHandler handler = entry.getValue();
            handler.onAuthenticationFailure(request2, response, exception);
            return;
        }
        this.defaultHandler.onAuthenticationFailure(request2, response, exception);
    }
}

