/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.context.DeferredSecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class SecurityContextHolderFilter
extends GenericFilterBean {
    private static final String FILTER_APPLIED = SecurityContextHolderFilter.class.getName() + ".APPLIED";
    private final SecurityContextRepository securityContextRepository;
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    public SecurityContextHolderFilter(SecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, "securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
    }

    @Override
    public void doFilter(ServletRequest request2, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request2, (HttpServletResponse)response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(HttpServletRequest request2, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (request2.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter(request2, response);
            return;
        }
        request2.setAttribute(FILTER_APPLIED, Boolean.TRUE);
        DeferredSecurityContext deferredContext = this.securityContextRepository.loadDeferredContext(request2);
        try {
            this.securityContextHolderStrategy.setDeferredContext(deferredContext);
            chain.doFilter(request2, response);
        }
        finally {
            this.securityContextHolderStrategy.clearContext();
            request2.removeAttribute(FILTER_APPLIED);
        }
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, "securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }
}

