/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Supplier;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRequestResolver;
import org.springframework.util.Assert;

@FunctionalInterface
public interface CsrfTokenRequestHandler
extends CsrfTokenRequestResolver {
    public void handle(HttpServletRequest var1, HttpServletResponse var2, Supplier<CsrfToken> var3);

    @Override
    default public String resolveCsrfTokenValue(HttpServletRequest request2, CsrfToken csrfToken) {
        Assert.notNull((Object)request2, "request cannot be null");
        Assert.notNull((Object)csrfToken, "csrfToken cannot be null");
        String actualToken = request2.getHeader(csrfToken.getHeaderName());
        if (actualToken == null) {
            actualToken = request2.getParameter(csrfToken.getParameterName());
        }
        return actualToken;
    }
}

