/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.firewall;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.security.web.firewall.RequestRejectedHandler;
import org.springframework.util.Assert;

public final class CompositeRequestRejectedHandler
implements RequestRejectedHandler {
    private final List<RequestRejectedHandler> requestRejectedhandlers;

    public CompositeRequestRejectedHandler(RequestRejectedHandler ... requestRejectedhandlers) {
        Assert.notEmpty((Object[])requestRejectedhandlers, "requestRejectedhandlers cannot be empty");
        this.requestRejectedhandlers = Arrays.asList(requestRejectedhandlers);
    }

    @Override
    public void handle(HttpServletRequest request2, HttpServletResponse response, RequestRejectedException requestRejectedException) throws IOException, ServletException {
        for (RequestRejectedHandler requestRejectedhandler : this.requestRejectedhandlers) {
            requestRejectedhandler.handle(request2, response, requestRejectedException);
        }
    }
}

