/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.firewall;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.security.web.firewall.RequestRejectedHandler;

public class HttpStatusRequestRejectedHandler
implements RequestRejectedHandler {
    private static final Log logger = LogFactory.getLog(HttpStatusRequestRejectedHandler.class);
    private final int httpError;

    public HttpStatusRequestRejectedHandler() {
        this.httpError = 400;
    }

    public HttpStatusRequestRejectedHandler(int httpError) {
        this.httpError = httpError;
    }

    @Override
    public void handle(HttpServletRequest request2, HttpServletResponse response, RequestRejectedException requestRejectedException) throws IOException {
        logger.debug(LogMessage.format("Rejecting request due to: %s", (Object)requestRejectedException.getMessage()), requestRejectedException);
        response.sendError(this.httpError);
    }
}

