/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class RequestHeaderRequestMatcher
implements RequestMatcher {
    private final String expectedHeaderName;
    private final String expectedHeaderValue;

    public RequestHeaderRequestMatcher(String expectedHeaderName) {
        this(expectedHeaderName, null);
    }

    public RequestHeaderRequestMatcher(String expectedHeaderName, String expectedHeaderValue) {
        Assert.notNull((Object)expectedHeaderName, "headerName cannot be null");
        this.expectedHeaderName = expectedHeaderName;
        this.expectedHeaderValue = expectedHeaderValue;
    }

    @Override
    public boolean matches(HttpServletRequest request2) {
        String actualHeaderValue = request2.getHeader(this.expectedHeaderName);
        if (this.expectedHeaderValue == null) {
            return actualHeaderValue != null;
        }
        return this.expectedHeaderValue.equals(actualHeaderValue);
    }

    public String toString() {
        return "RequestHeaderRequestMatcher [expectedHeaderName=" + this.expectedHeaderName + ", expectedHeaderValue=" + this.expectedHeaderValue + "]";
    }
}

