/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ClassUtils;

class MergedContextConfigurationRuntimeHints {
    private static final String SLASH = "/";
    private static final String WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME = "org.springframework.test.context.web.WebMergedContextConfiguration";
    private static final String GET_RESOURCE_BASE_PATH_METHOD_NAME = "getResourceBasePath";
    private static final Class<?> webMergedContextConfigurationClass = MergedContextConfigurationRuntimeHints.loadWebMergedContextConfigurationClass();
    private static final Method getResourceBasePathMethod = MergedContextConfigurationRuntimeHints.loadGetResourceBasePathMethod();

    MergedContextConfigurationRuntimeHints() {
    }

    public void registerHints(RuntimeHints runtimeHints, MergedContextConfiguration mergedConfig, ClassLoader classLoader) {
        ContextLoader contextLoader = mergedConfig.getContextLoader();
        if (contextLoader != null) {
            this.registerDeclaredConstructors(contextLoader.getClass(), runtimeHints);
        }
        mergedConfig.getContextInitializerClasses().forEach(clazz -> this.registerDeclaredConstructors((Class<?>)clazz, runtimeHints));
        this.registerClasspathResources(mergedConfig.getLocations(), runtimeHints, classLoader);
        this.registerClasspathResources(mergedConfig.getPropertySourceLocations(), runtimeHints, classLoader);
        if (webMergedContextConfigurationClass.isInstance(mergedConfig)) {
            String resourceBasePath = null;
            try {
                resourceBasePath = (String)getResourceBasePathMethod.invoke((Object)mergedConfig, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to invoke WebMergedContextConfiguration#getResourceBasePath()", ex);
            }
            this.registerClasspathResourceDirectoryStructure(resourceBasePath, runtimeHints);
        }
    }

    private void registerDeclaredConstructors(Class<?> type, RuntimeHints runtimeHints) {
        runtimeHints.reflection().registerType(type, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
    }

    private void registerClasspathResources(String[] paths, RuntimeHints runtimeHints, ClassLoader classLoader) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(classLoader);
        Arrays.stream(paths).filter(path -> path.startsWith("classpath:")).map(resourceLoader::getResource).forEach(runtimeHints.resources()::registerResource);
    }

    private void registerClasspathResourceDirectoryStructure(String directory, RuntimeHints runtimeHints) {
        if (directory.startsWith("classpath:")) {
            Object pattern = directory.substring("classpath:".length());
            if (((String)pattern).startsWith(SLASH)) {
                pattern = ((String)pattern).substring(1);
            }
            if (!((String)pattern).endsWith(SLASH)) {
                pattern = (String)pattern + SLASH;
            }
            pattern = (String)pattern + "*";
            runtimeHints.resources().registerPattern((String)pattern);
        }
    }

    private static Class<?> loadWebMergedContextConfigurationClass() {
        try {
            return ClassUtils.forName(WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME, MergedContextConfigurationRuntimeHints.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError ex) {
            throw new IllegalStateException("Failed to load class org.springframework.test.context.web.WebMergedContextConfiguration", ex);
        }
    }

    private static Method loadGetResourceBasePathMethod() {
        try {
            return webMergedContextConfigurationClass.getMethod(GET_RESOURCE_BASE_PATH_METHOD_NAME, new Class[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to load method WebMergedContextConfiguration#getResourceBasePath()", ex);
        }
    }
}

