/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.response;

import java.io.IOException;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class ExecutingResponseCreator
implements ResponseCreator {
    private final ClientHttpRequestFactory requestFactory;

    public ExecutingResponseCreator(ClientHttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @Override
    public ClientHttpResponse createResponse(ClientHttpRequest request2) throws IOException {
        Assert.state(request2 instanceof MockClientHttpRequest, "Expected a MockClientHttpRequest");
        MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
        ClientHttpRequest newRequest = this.requestFactory.createRequest(mockRequest.getURI(), mockRequest.getMethod());
        newRequest.getHeaders().putAll(mockRequest.getHeaders());
        StreamUtils.copy(mockRequest.getBodyAsBytes(), newRequest.getBody());
        return newRequest.execute();
    }
}

