/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.Assert;

public class RequestResultMatchers {
    protected RequestResultMatchers() {
    }

    public ResultMatcher asyncStarted() {
        return result -> RequestResultMatchers.assertAsyncStarted(result.getRequest());
    }

    public ResultMatcher asyncNotStarted() {
        return result -> AssertionErrors.assertFalse("Async started", result.getRequest().isAsyncStarted());
    }

    public <T> ResultMatcher asyncResult(Matcher<? super T> matcher) {
        return result -> {
            MockHttpServletRequest request2 = result.getRequest();
            RequestResultMatchers.assertAsyncStarted(request2);
            MatcherAssert.assertThat("Async result", result.getAsyncResult(), matcher);
        };
    }

    public ResultMatcher asyncResult(@Nullable Object expectedResult) {
        return result -> {
            MockHttpServletRequest request2 = result.getRequest();
            RequestResultMatchers.assertAsyncStarted(request2);
            AssertionErrors.assertEquals("Async result", expectedResult, result.getAsyncResult());
        };
    }

    public <T> ResultMatcher attribute(String name, Matcher<? super T> matcher) {
        return result -> {
            Object value = result.getRequest().getAttribute(name);
            MatcherAssert.assertThat("Request attribute '" + name + "'", value, matcher);
        };
    }

    public ResultMatcher attribute(String name, @Nullable Object expectedValue) {
        return result -> AssertionErrors.assertEquals("Request attribute '" + name + "'", expectedValue, result.getRequest().getAttribute(name));
    }

    public <T> ResultMatcher sessionAttribute(String name, Matcher<? super T> matcher) {
        return result -> {
            HttpSession session = result.getRequest().getSession();
            Assert.state(session != null, "No HttpSession");
            Object value = session.getAttribute(name);
            MatcherAssert.assertThat("Session attribute '" + name + "'", value, matcher);
        };
    }

    public ResultMatcher sessionAttribute(String name, @Nullable Object value) {
        return result -> {
            HttpSession session = result.getRequest().getSession();
            Assert.state(session != null, "No HttpSession");
            AssertionErrors.assertEquals("Session attribute '" + name + "'", value, session.getAttribute(name));
        };
    }

    public ResultMatcher sessionAttributeDoesNotExist(String ... names) {
        return result -> {
            HttpSession session = result.getRequest().getSession();
            Assert.state(session != null, "No HttpSession");
            for (String name : names) {
                AssertionErrors.assertNull("Session attribute '" + name + "' exists", session.getAttribute(name));
            }
        };
    }

    private static void assertAsyncStarted(HttpServletRequest request2) {
        AssertionErrors.assertTrue("Async not started", request2.isAsyncStarted());
    }
}

