/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.observation.ServerHttpObservationDocumentation;
import org.springframework.http.server.observation.ServerRequestObservationContext;
import org.springframework.http.server.observation.ServerRequestObservationConvention;
import org.springframework.lang.Nullable;
import org.springframework.web.filter.OncePerRequestFilter;

public class ServerHttpObservationFilter
extends OncePerRequestFilter {
    public static final String CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE = ServerHttpObservationFilter.class.getName() + ".context";
    private static final ServerRequestObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultServerRequestObservationConvention();
    private static final String CURRENT_OBSERVATION_ATTRIBUTE = ServerHttpObservationFilter.class.getName() + ".observation";
    private final ObservationRegistry observationRegistry;
    private final ServerRequestObservationConvention observationConvention;

    public ServerHttpObservationFilter(ObservationRegistry observationRegistry) {
        this(observationRegistry, DEFAULT_OBSERVATION_CONVENTION);
    }

    public ServerHttpObservationFilter(ObservationRegistry observationRegistry, ServerRequestObservationConvention observationConvention) {
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    public static Optional<ServerRequestObservationContext> findObservationContext(HttpServletRequest request2) {
        return Optional.ofNullable((ServerRequestObservationContext)request2.getAttribute(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE));
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request2, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Observation observation = this.createOrFetchObservation(request2, response);
        try (Observation.Scope scope = observation.openScope();){
            filterChain.doFilter(request2, response);
        }
        catch (Exception ex) {
            observation.error(this.unwrapServletException(ex));
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            throw ex;
        }
        finally {
            if (!request2.isAsyncStarted()) {
                Throwable error = this.fetchException(request2);
                if (error != null) {
                    observation.error(error);
                }
                observation.stop();
            }
        }
    }

    private Observation createOrFetchObservation(HttpServletRequest request2, HttpServletResponse response) {
        Observation observation = (Observation)request2.getAttribute(CURRENT_OBSERVATION_ATTRIBUTE);
        if (observation == null) {
            ServerRequestObservationContext context = new ServerRequestObservationContext(request2, response);
            observation = ServerHttpObservationDocumentation.HTTP_SERVLET_SERVER_REQUESTS.observation(this.observationConvention, DEFAULT_OBSERVATION_CONVENTION, () -> context, this.observationRegistry).start();
            request2.setAttribute(CURRENT_OBSERVATION_ATTRIBUTE, observation);
            if (!observation.isNoop()) {
                request2.setAttribute(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE, observation.getContext());
            }
        }
        return observation;
    }

    private Throwable unwrapServletException(Throwable ex) {
        return ex instanceof ServletException ? ex.getCause() : ex;
    }

    @Nullable
    private Throwable fetchException(HttpServletRequest request2) {
        return (Throwable)request2.getAttribute("jakarta.servlet.error.exception");
    }
}

