/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

public abstract class AbstractHandlerMethodExceptionResolver
extends AbstractHandlerExceptionResolver {
    @Override
    protected boolean shouldApplyTo(HttpServletRequest request2, @Nullable Object handler) {
        if (handler == null) {
            return super.shouldApplyTo(request2, null);
        }
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            handler = handlerMethod.getBean();
            return super.shouldApplyTo(request2, handler);
        }
        if (this.hasGlobalExceptionHandlers() && this.hasHandlerMappings()) {
            return super.shouldApplyTo(request2, handler);
        }
        return false;
    }

    protected boolean hasGlobalExceptionHandlers() {
        return false;
    }

    @Override
    @Nullable
    protected final ModelAndView doResolveException(HttpServletRequest request2, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        HandlerMethod handlerMethod = handler instanceof HandlerMethod ? (HandlerMethod)handler : null;
        return this.doResolveHandlerMethodException(request2, response, handlerMethod, ex);
    }

    @Nullable
    protected abstract ModelAndView doResolveHandlerMethodException(HttpServletRequest var1, HttpServletResponse var2, @Nullable HandlerMethod var3, Exception var4);
}

