/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.mvc.condition.AbstractNameValueExpression;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.util.WebUtils;

public final class ParamsRequestCondition
extends AbstractRequestCondition<ParamsRequestCondition> {
    private final Set<ParamExpression> expressions;

    public ParamsRequestCondition(String ... params) {
        this.expressions = ParamsRequestCondition.parseExpressions(params);
    }

    private static Set<ParamExpression> parseExpressions(String ... params) {
        if (ObjectUtils.isEmpty(params)) {
            return Collections.emptySet();
        }
        LinkedHashSet<ParamExpression> expressions = new LinkedHashSet<ParamExpression>(params.length);
        for (String param : params) {
            expressions.add(new ParamExpression(param));
        }
        return expressions;
    }

    private ParamsRequestCondition(Set<ParamExpression> conditions) {
        this.expressions = conditions;
    }

    public Set<NameValueExpression<String>> getExpressions() {
        return new LinkedHashSet<NameValueExpression<String>>(this.expressions);
    }

    @Override
    protected Collection<ParamExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    @Override
    public ParamsRequestCondition combine(ParamsRequestCondition other) {
        if (this.isEmpty() && other.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        LinkedHashSet<ParamExpression> set2 = new LinkedHashSet<ParamExpression>(this.expressions);
        set2.addAll(other.expressions);
        return new ParamsRequestCondition(set2);
    }

    @Override
    @Nullable
    public ParamsRequestCondition getMatchingCondition(HttpServletRequest request2) {
        for (ParamExpression expression : this.expressions) {
            if (expression.match(request2)) continue;
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(ParamsRequestCondition other, HttpServletRequest request2) {
        int result = other.expressions.size() - this.expressions.size();
        if (result != 0) {
            return result;
        }
        return (int)(this.getValueMatchCount(other.expressions) - this.getValueMatchCount(this.expressions));
    }

    private long getValueMatchCount(Set<ParamExpression> expressions) {
        long count = 0L;
        for (ParamExpression e : expressions) {
            if (e.getValue() == null || e.isNegated()) continue;
            ++count;
        }
        return count;
    }

    static class ParamExpression
    extends AbstractNameValueExpression<String> {
        private final Set<String> namesToMatch = new HashSet<String>(WebUtils.SUBMIT_IMAGE_SUFFIXES.length + 1);

        ParamExpression(String expression) {
            super(expression);
            this.namesToMatch.add(this.getName());
            for (String suffix : WebUtils.SUBMIT_IMAGE_SUFFIXES) {
                this.namesToMatch.add(this.getName() + suffix);
            }
        }

        @Override
        protected boolean isCaseSensitiveName() {
            return true;
        }

        @Override
        protected String parseValue(String valueExpression) {
            return valueExpression;
        }

        @Override
        protected boolean matchName(HttpServletRequest request2) {
            for (String current : this.namesToMatch) {
                if (request2.getParameterMap().get(current) == null) continue;
                return true;
            }
            return request2.getParameterMap().containsKey(this.name);
        }

        @Override
        protected boolean matchValue(HttpServletRequest request2) {
            return ObjectUtils.nullSafeEquals(this.value, request2.getParameter(this.name));
        }
    }
}

